/*
 * Decompiled with CFR 0.152.
 */
package com.els.web.filter;

import com.alibaba.fastjson.JSONObject;
import com.els.dao.AccountMapper;
import com.els.dao.ElsSubaccountParamMapper;
import com.els.dao.RedisClusterDao;
import com.els.dao.SystemLogMapper;
import com.els.enumerate.LanguageEnum;
import com.els.message.listener.OnlineUserListener;
import com.els.service.I18nService;
import com.els.util.IpUtil;
import com.els.util.SpringContextHelper;
import com.els.util.SystemUtil;
import com.els.util.TokenUtil;
import com.els.vo.ElsSubaccountParamVO;
import com.els.vo.EnterpriseVO;
import com.els.vo.I18nVO;
import com.els.vo.SubAccountVO;
import com.els.vo.SystemLogVO;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHDZLoginFilter
implements Filter {
    private static final String LHDZ_ELSACCOUNT = "540000";
    private static final Logger logger = LoggerFactory.getLogger(LHDZLoginFilter.class);
    private final RedisClusterDao redisDao = new RedisClusterDao();
    private static final String VENDOR = "vendor";
    private static final String LOGIN = "/login/login.html";
    private static final String LOGINLD = "/login/loginLD.html";
    private static final String LANNAME = "languageName";
    private static final String LOCALE = "Locale";

    public void destroy() {
        System.out.println("");
    }

    public void doFilter(ServletRequest request2, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        System.out.println("\u8fdb\u5165\u8fc7\u6ee4\u5668");
        HttpServletRequest request = (HttpServletRequest)request2;
        System.out.println("--\u5f53\u524dsessionid---" + request.getSession().getId());
        HttpServletResponse res = (HttpServletResponse)response;
        String url = request.getRequestURL().toString();
        System.out.println("\u8bf7\u6c42\u7684url:" + url);
        String token = request2.getParameter("token");
        String userName = "";
        boolean sigleLogin = true;
        if (OnlineUserListener.getRemovesessionidmap().containsKey(request.getSession().getId())) {
            request.getSession().invalidate();
            OnlineUserListener.getRemovesessionidmap().remove(request.getSession().getId());
            sigleLogin = false;
        }
        try {
            userName = TokenUtil.anlysisToken((String)token);
        }
        catch (Exception e) {
            if (url.contains(VENDOR)) {
                res.sendRedirect(String.valueOf(url.substring(0, url.indexOf(request.getContextPath()))) + request.getContextPath() + LOGIN);
            } else {
                res.sendRedirect(String.valueOf(url.substring(0, url.indexOf(request.getContextPath()))) + request.getContextPath() + LOGINLD);
            }
            return;
        }
        if (StringUtils.isNotBlank((String)((String)request.getSession().getAttribute("elsAccount")))) {
            logger.info("\u5df2\u767b\u5165\u8fc7\uff1a" + (String)request.getSession().getAttribute("elsAccount"));
            chain.doFilter(request2, response);
        } else {
            System.out.println("--\u91c7\u8d2d\u65b9\u5355\u70b9\u767b\u5165\uff0c\u7b2c\u4e00\u6b21\u52a0\u8f7d---" + userName);
            if (StringUtils.isBlank((String)userName)) {
                String loginUrl = url.contains(VENDOR) ? String.valueOf(url.substring(0, url.indexOf(request.getContextPath()))) + request.getContextPath() + LOGIN : String.valueOf(url.substring(0, url.indexOf(request.getContextPath()))) + request.getContextPath() + LOGINLD;
                if (!sigleLogin) {
                    loginUrl = String.valueOf(loginUrl) + "?msg=" + URLEncoder.encode("\u8be5\u8d26\u53f7\u5df2\u4ece\u5176\u5b83\u5730\u65b9\u767b\u9646\uff0c\u60a8\u5c06\u88ab\u5f3a\u5236\u9000\u51fa\uff0c\u5982\u6000\u7591\u8d26\u53f7\u88ab\u76d7\u7528\uff0c\u8bf7\u5c3d\u5feb\u4fee\u6539\u4f60\u7684\u5bc6\u7801\uff0c\u5e76\u901a\u77e5\u76f8\u5173\u4eba\u5458", "utf-8");
                }
                res.sendRedirect(loginUrl);
                return;
            }
            String elsAccount = LHDZ_ELSACCOUNT;
            try {
                String elsSubAccount = userName;
                SubAccountVO subAccountVO = new SubAccountVO();
                subAccountVO.setElsAccount(elsAccount);
                subAccountVO.setMaterialCate(elsSubAccount);
                System.out.println("\u8bbf\u95eeSRM\u767b\u5165\u8d26\u53f7\uff1aelsAccount:" + elsAccount + ",elsSubAccount:" + elsSubAccount);
                AccountMapper accountMapper2 = (AccountMapper)SpringContextHelper.getBean((String)"accountMapper");
                List list = accountMapper2.findSubAccountByMaterialCate(subAccountVO);
                if (list == null || list.size() == 0) {
                    System.out.println(String.valueOf(elsAccount) + "_" + elsSubAccount + "\u672a\u67e5\u8be2\u5230\u767b\u5165\u8005\u5728SRM\u6ce8\u518c");
                    if (url.contains(VENDOR)) {
                        res.sendRedirect(String.valueOf(url.substring(0, url.indexOf(request.getContextPath()))) + request.getContextPath() + LOGIN);
                    } else {
                        res.sendRedirect(String.valueOf(url.substring(0, url.indexOf(request.getContextPath()))) + request.getContextPath() + LOGINLD);
                    }
                    return;
                }
                final SubAccountVO acount = (SubAccountVO)list.get(0);
                request.getSession().invalidate();
                request.getSession().setAttribute("elsAccount", (Object)acount.getElsAccount());
                request.getSession().setAttribute("elsSubAccount", (Object)acount.getElsSubAccount());
                request.getSession().setAttribute("username", (Object)acount.getName());
                request.getSession().setAttribute("role", (Object)acount.getStation());
                request.getSession().setAttribute("isAdmin", (Object)acount.getIsAdmin());
                request.getSession().setAttribute("logo", (Object)acount.getLogo());
                request.getSession().setAttribute("employeeNumber", (Object)acount.getEmployeeNumber());
                request.getSession().setAttribute("nickname", (Object)acount.getNickname());
                request.getSession().setAttribute("wxAccount", (Object)acount.getWxAccount());
                request.getSession().setAttribute("qqAccount", (Object)acount.getQqAccount());
                request.getSession().setAttribute("roleName", (Object)acount.getRoleName());
                request.getSession().setAttribute("telphone", (Object)(StringUtils.isNotBlank((String)acount.getTelphone1()) ? acount.getTelphone1() : acount.getTelphone2()));
                request.getSession().setAttribute("email", (Object)acount.getEmail());
                request.getSession().setAttribute("fax", (Object)acount.getFax());
                request.getSession().setAttribute("userID", (Object)acount.getMaterialCate());
                request.getSession().setAttribute("userRole", (Object)acount.getStation());
                EnterpriseVO enterpriseVO = accountMapper2.findEnterpriseByNumber(acount.getElsAccount());
                if (enterpriseVO != null) {
                    request.getSession().setAttribute("fullName", (Object)enterpriseVO.getFullName());
                    request.getSession().setAttribute("companyShortName", (Object)enterpriseVO.getShortName());
                }
                final String language = acount.getLanguage();
                if (LanguageEnum.CN.getValue().equalsIgnoreCase(language)) {
                    request.getSession().setAttribute("language", (Object)LanguageEnum.CN.getValue());
                    request.getSession().setAttribute(LANNAME, (Object)LanguageEnum.CN.getDesc());
                    request.getSession().setAttribute(LOCALE, (Object)Locale.SIMPLIFIED_CHINESE);
                    Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
                } else if (LanguageEnum.EN.getValue().equalsIgnoreCase(language)) {
                    request.getSession().setAttribute("language", (Object)LanguageEnum.EN.getValue());
                    request.getSession().setAttribute(LANNAME, (Object)LanguageEnum.EN.getDesc());
                    request.getSession().setAttribute(LOCALE, (Object)Locale.US);
                    Locale.setDefault(Locale.US);
                } else if (LanguageEnum.CN_TW.getValue().equalsIgnoreCase(language)) {
                    request.getSession().setAttribute("language", (Object)LanguageEnum.CN_TW.getValue());
                    request.getSession().setAttribute(LANNAME, (Object)LanguageEnum.CN_TW.getDesc());
                    request.getSession().setAttribute(LOCALE, (Object)Locale.TRADITIONAL_CHINESE);
                    Locale.setDefault(Locale.TRADITIONAL_CHINESE);
                } else {
                    request.getSession().setAttribute(LOCALE, (Object)Locale.getDefault());
                    request.getSession().setAttribute("language", (Object)"zh_cn");
                }
                ElsSubaccountParamMapper elsSubaccountParamMapper = (ElsSubaccountParamMapper)SpringContextHelper.getBean(ElsSubaccountParamMapper.class);
                ElsSubaccountParamVO param = new ElsSubaccountParamVO();
                param.setElsAccount(elsAccount);
                param.setElsSubAccount(elsSubAccount);
                List lstData = elsSubaccountParamMapper.getParams(param);
                HashMap<String, String> map = new HashMap<String, String>();
                for (ElsSubaccountParamVO paramVO : lstData) {
                    map.put(paramVO.getParamId(), paramVO.getParamValue());
                }
                String json = JSONObject.toJSON(map).toString();
                request.getSession().setAttribute("params", (Object)json);
                final String ip = IpUtil.getIpAddr((HttpServletRequest)request);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!LHDZLoginFilter.this.redisDao.getList("key_onlineUserList#").contains(acount.getName())) {
                            LHDZLoginFilter.this.redisDao.lpush("key_onlineUserList#", acount.getName());
                        }
                        if (!LHDZLoginFilter.this.redisDao.getList("key_onlineElsAccountList#").contains(String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount())) {
                            LHDZLoginFilter.this.redisDao.lpush("key_onlineElsAccountList#", String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount());
                        }
                        SystemLogVO logVO = new SystemLogVO();
                        logVO.setElsAccount(acount.getElsAccount());
                        logVO.setElsSubAccount(String.valueOf(acount.getElsSubAccount()) + "_" + acount.getName());
                        logVO.setOperation("login");
                        logVO.setModule("login");
                        logVO.setDescription("\u767b\u9646\u7cfb\u7edf");
                        logVO.setClientIP(ip);
                        logVO.setLogtime(new Date());
                        logVO.setClientOs(acount.getClientOs());
                        logVO.setClientType(acount.getClientType());
                        logVO.setBrowser(acount.getBrowser());
                        logVO.setLanguage(language);
                        LHDZLoginFilter.this.setIpAdress(ip, logVO);
                        LHDZLoginFilter.this.log(logVO);
                    }
                }).start();
                logger.info(String.valueOf(acount.getName()) + "\u4e0a\u7ebf\u4e86");
            }
            catch (Exception e) {
                logger.info("\u767b\u5f55\u9519\u8bef:" + e.getMessage());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("elsAccount", elsAccount);
                map.put("exception", String.valueOf(this.getI18n("i18n_account_error_loginError", "\u767b\u5f55\u51fa\u9519:", new Object[0])) + e.getMessage());
            }
            chain.doFilter(request2, response);
        }
    }

    private void setIpAdress(String ip, SystemLogVO logVO) {
        Map addressMap = IpUtil.getLocationFromIp((String)ip);
        logVO.setCountry((String)addressMap.get("country"));
        logVO.setRegion((String)addressMap.get("region"));
        logVO.setCity((String)addressMap.get("city"));
    }

    public void log(SystemLogVO systemLogVO) {
        SystemLogMapper systemLogMapper = (SystemLogMapper)SpringContextHelper.getBean(SystemLogMapper.class);
        systemLogMapper.insert(systemLogVO);
    }

    public String getI18n(String key, String defaultValue, Object ... args) {
        String value = defaultValue;
        I18nService i18nService2 = (I18nService)SpringContextHelper.getBean(I18nService.class);
        Response response = i18nService2.getResourceByKey(key);
        if (response.getEntity() instanceof I18nVO) {
            I18nVO i18nVO = (I18nVO)response.getEntity();
            value = SystemUtil.isNotEmpty((String)i18nVO.getValue()) ? i18nVO.getValue() : String.format(i18nVO.getValue(), args);
        }
        return value;
    }

    public void init(FilterConfig arg0) throws ServletException {
        System.out.println("");
    }
}

