/*
 * Decompiled with CFR 0.152.
 */
package com.els.web.tag;

import com.alibaba.druid.util.StringUtils;
import com.els.enumerate.LanguageEnum;
import com.els.service.I18nService;
import com.els.service.impl.I18nServiceImpl;
import com.els.util.SpringContextHelper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class I18nTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private I18nService i18nService = (I18nService)SpringContextHelper.getBean((String)"i18nServiceImpl");
    private String key;
    private String defaultValue;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        if ("true".equals(I18nServiceImpl.getI18nIgnore())) {
            try {
                out.print(this.defaultValue);
            }
            catch (Exception e) {
                try {
                    throw new Exception(e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.doStartTag();
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String language = (String)request.getSession().getAttribute("language");
        String elsAccount = (String)request.getSession().getAttribute("elsAccount");
        String value = this.i18nService.getValue(elsAccount, this.key, language);
        try {
            if (StringUtils.isEmpty((String)value)) {
                this.i18nService.i18nChinessRecordInit(this.key, this.defaultValue);
                value = this.i18nService.getValue(elsAccount, this.key, LanguageEnum.EN.getValue());
                if (StringUtils.isEmpty((String)value)) {
                    out.print(this.defaultValue);
                } else {
                    out.print(value);
                }
            } else {
                out.print(value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspTagException {
        return 6;
    }
}

