/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.batchRule;

import com.els.base.core.exception.CommonException;
import com.els.liby.collection.batchRule.impl.FeedRuleImpl;
import com.els.liby.collection.batchRule.impl.Oem300RuleImpl;
import com.els.liby.collection.batchRule.impl.Oem301RuleImpl;
import com.els.liby.collection.batchRule.impl.Oem310011RuleImpl;
import com.els.liby.collection.batchRule.impl.Oem310012RuleImpl;
import com.els.liby.collection.batchRule.impl.Oem310013RuleImpl;
import com.els.liby.util.OemContextUtils;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public abstract class BatchRuleUtils {
    public static String getBatch(String orderType, String purchaseGroup, String factoryCode, Date createTime, Date backTime) {
        String type;
        String factoryShortcode = "";
        if (StringUtils.isNotBlank((String)factoryCode)) {
            factoryShortcode = OemContextUtils.getOrganizationService().getAbbreviationByCode(factoryCode);
        }
        switch (type = orderType + (StringUtils.isBlank((String)purchaseGroup) ? "" : "-" + purchaseGroup)) {
            case "C100": 
            case "C20": 
            case "Z100": 
            case "Z200": {
                FeedRuleImpl feedRule = new FeedRuleImpl(createTime, factoryCode);
                return feedRule.ruleCode();
            }
            case "C300": 
            case "Z300": {
                Oem300RuleImpl oem300Rule = new Oem300RuleImpl(createTime, factoryShortcode);
                return oem300Rule.ruleCode();
            }
            case "C310-011": 
            case "Z310-011": {
                Oem310011RuleImpl oem310011Rule = new Oem310011RuleImpl(createTime, factoryShortcode, backTime);
                return oem310011Rule.ruleCode();
            }
            case "C310-012": 
            case "Z310-012": {
                Oem310012RuleImpl oem310012Rule = new Oem310012RuleImpl(createTime, factoryShortcode);
                return oem310012Rule.ruleCode();
            }
            case "C310-013": 
            case "Z310-013": {
                Oem310013RuleImpl oem310013Rule = new Oem310013RuleImpl(createTime, factoryShortcode, backTime);
                return oem310013Rule.ruleCode();
            }
            case "C301": 
            case "Z301": {
                Oem301RuleImpl oem301Rule = new Oem301RuleImpl(createTime);
                return oem301Rule.ruleCode();
            }
        }
        throw new CommonException("\u8ba2\u5355\u7c7b\u578b\uff1a" + orderType + "\uff1b" + (StringUtils.isBlank((String)purchaseGroup) ? "" : "\u91c7\u8d2d\u7ec4\uff1a" + purchaseGroup) + "\u6ca1\u6709\u5339\u914d\u7684\u6279\u6b21\u751f\u6210\u89c4\u5219");
    }

    public static String getFeedBatch(String orderType, Date createTime, String factoryCode) {
        return BatchRuleUtils.getBatch(orderType, null, factoryCode, createTime, null);
    }

    public static String getOemBatch(String orderType, String purchaseGroup, String factoryCode, Date createTime, Date backTime) {
        switch (orderType) {
            case "C310": 
            case "Z310": {
                return BatchRuleUtils.getBatch(orderType, purchaseGroup, factoryCode, createTime, backTime);
            }
        }
        return BatchRuleUtils.getBatch(orderType, null, factoryCode, createTime, backTime);
    }
}

