/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.liby.collection.utils.OemOrderItemUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

public class ModifyOemOrderItemCanDeliveryCmd
extends AbstractCommand {
    private List<String> ItemIds;

    public ModifyOemOrderItemCanDeliveryCmd(List<String> ItemIds) {
        this.ItemIds = ItemIds;
    }

    public Object execute(ICommandInvoker context) {
        Assert.isNotEmpty(this.ItemIds, (String)"\u91c7\u8d2d\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        for (String orderItemId : this.ItemIds) {
            Integer canDeliveryStatus = this.getCanDeliveryStatus(orderItemId);
            if (canDeliveryStatus == null) continue;
            PurchaseOrderItem item = new PurchaseOrderItem();
            item.setId(orderItemId);
            item.setIsCanDelivery(canDeliveryStatus);
            ContextUtils.getPurchaseOrderItemService().modifyObj((Serializable)item);
        }
        return null;
    }

    private Integer getCanDeliveryStatus(String orderItemId) {
        Integer canDeliveryStatus = null;
        PurchaseOrderItem purOrderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById((Object)orderItemId);
        BigDecimal CanDeliveryQuantity = OemOrderItemUtils.getCanDeliveryQuantity(null, purOrderItem.getQuantity(), purOrderItem.getId());
        if (CanDeliveryQuantity.compareTo(BigDecimal.ZERO) <= 0 && Constant.YES_INT.equals(purOrderItem.getIsCanDelivery())) {
            canDeliveryStatus = Constant.NO_INT;
        }
        if (CanDeliveryQuantity.compareTo(BigDecimal.ZERO) > 0 && Constant.NO_INT.equals(purOrderItem.getIsCanDelivery())) {
            canDeliveryStatus = Constant.YES_INT;
        }
        return canDeliveryStatus;
    }
}

