/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.purchase.entity.PurOrderItemBomExample;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.liby.collection.feed.entity.OemFeedOrderItem;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.collection.utils.OemOrderItems;
import com.els.liby.util.OemContextUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ViewOemInsteadOrderCommand
extends AbstractCommand<OemOrderItems> {
    private static int IN_COUNT = 1000;
    private List<String> types;
    private List<String> factorys;
    private QueryParamWapper wapper;

    public ViewOemInsteadOrderCommand(List<String> types, List<String> factorys, QueryParamWapper wapper) {
        this.types = types;
        this.factorys = factorys;
        this.wapper = wapper;
    }

    public OemOrderItems execute(ICommandInvoker context) {
        List<OemFeedOrderItem> itemList;
        PurchaseOrderExample orderExample = new PurchaseOrderExample();
        PurchaseOrderExample.Criteria orderExampleCriteria = orderExample.createCriteria();
        orderExampleCriteria.andOrderTypeIn(this.types).andOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andReturnFlagIsNull().andDeliveryStatusNotEqualTo(PurchaseOrderDeliveryStatusEnum.RECEIVED_ALL.getValue()).andIsEnableEqualTo(Constant.YES_INT);
        OemOrderItemUtils.resolveWapper(orderExample, this.wapper);
        List<String> purOrderIds = OemOrderItemUtils.getOrderIdsByType(orderExample);
        OemOrderItems oemOrderItems = new OemOrderItems();
        if (CollectionUtils.isEmpty(purOrderIds)) {
            return oemOrderItems;
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setOrderByClause(" ORDER_NO DESC");
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        if (purOrderIds.size() > IN_COUNT) {
            criteria.andOrderIdIn(purOrderIds.subList(0, IN_COUNT - 1));
            Lists.partition(purOrderIds.subList(IN_COUNT, purOrderIds.size()), (int)1000).forEach(lists -> example.or().andOrderIdIn(lists));
        } else {
            criteria.andOrderIdIn(purOrderIds);
        }
        criteria.andFactoryIn(this.factorys);
        criteria.andFinishFlagNotEqualTo("Y");
        criteria.andOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        criteria.andReturnFlagIsNull();
        criteria.andIsCanDeliveryEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (this.wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)this.wapper);
        }
        if (CollectionUtils.isEmpty(itemList = OemContextUtils.getOemFeedOrderItemExtService().selectInsteadByExample(example))) {
            return oemOrderItems;
        }
        oemOrderItems.setItems(itemList);
        List itemIds = itemList.stream().map(item -> item.getId()).collect(Collectors.toList());
        PurDeliveryPlanItemExample planItemExample = new PurDeliveryPlanItemExample();
        if (itemIds.size() > IN_COUNT) {
            planItemExample.createCriteria().andPurOrderItemIdIn(itemIds.subList(0, IN_COUNT - 1));
            Lists.partition(itemIds.subList(IN_COUNT, purOrderIds.size()), (int)1000).forEach(lists -> planItemExample.or().andPurOrderItemIdIn(lists));
        } else {
            planItemExample.createCriteria().andPurOrderItemIdIn(itemIds);
        }
        List planItemList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)planItemExample);
        oemOrderItems.setPlanItemList(planItemList);
        PurOrderItemBomExample bomExample = new PurOrderItemBomExample();
        bomExample.createCriteria().andOrderItemIdIn(itemIds);
        if (itemIds.size() > IN_COUNT) {
            bomExample.createCriteria().andOrderItemIdIn(itemIds.subList(0, IN_COUNT - 1));
            Lists.partition(itemIds.subList(IN_COUNT, purOrderIds.size()), (int)1000).forEach(lists -> bomExample.or().andOrderItemIdIn(lists));
        } else {
            bomExample.createCriteria().andOrderItemIdIn(itemIds);
        }
        List bomList = ContextUtils.getPurOrderItemBomService().queryAllObjByExample((IExample)bomExample);
        oemOrderItems.setBomList(bomList);
        return oemOrderItems;
    }
}

