/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.liby.collection.batchRule.BatchRuleUtils;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.feed.entity.OemFeedExample;
import com.els.liby.collection.feed.sap.BAPI2017GMHEADRET;
import com.els.liby.collection.feed.sap.ZSRMDSHRFCRET;
import com.els.liby.collection.feed.sap.ZSRMDSHRFCRETPZ;
import com.els.liby.collection.feed.sap.ZSRMRFCJGLDSRKResponse;
import com.els.liby.quota.service.SoapServiceRequestText;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectedBackSapCommand
extends AbstractCommand<List<String>> {
    private static final Logger log = LoggerFactory.getLogger(CollectedBackSapCommand.class);
    private static String username = OemSapConfUtils.getServiceUsername();
    private static String password = OemSapConfUtils.getServicePassword();
    private static String serviceUrl = OemSapConfUtils.getOemFeedUrl();
    private static String serviceNameSpace = OemSapConfUtils.getNameSpace();
    private static String serviceMethod = OemSapConfUtils.getOemFeedServiceMethod();
    private static String PAT = "000000000000000000";
    private List<OemFeed> oemFeeds;

    public CollectedBackSapCommand(List<OemFeed> oemFeeds) {
        this.oemFeeds = oemFeeds;
    }

    public List<String> execute(ICommandInvoker context) {
        HashMap<String, String> SapBacthMap = new HashMap<String, String>();
        this.initSapBatchNum(this.oemFeeds, SapBacthMap);
        ZSRMRFCJGLDSRKResponse response = this.getDataFromSap(this.oemFeeds);
        List<ZSRMDSHRFCRET> lists = response.getETINFO().getItem();
        Assert.isNotEmpty(lists, (String)"SAP\u751f\u6210\u51ed\u8bc1\u5931\u8d25");
        List<String> VoucherCodes = lists.stream().map(z -> {
            String code = z.getZDSHPZ();
            if ("S".equals(z.getTYPE())) {
                this.confirmSuccess(code, z.getPZITEM().getItem(), SapBacthMap);
                return code;
            }
            this.confirmFail(code, z.getMSG());
            return null;
        }).filter(code -> StringUtils.isNotBlank((String)code)).collect(Collectors.toList());
        return VoucherCodes;
    }

    private void initSapBatchNum(List<OemFeed> oemFeeds, Map<String, String> sapBacthMap) {
        oemFeeds.stream().forEach(feed -> {
            String sapBatch = BatchRuleUtils.getFeedBatch(feed.getOrderType(), new Date(), feed.getFactory());
            feed.setSapBatchNumber(sapBatch);
            sapBacthMap.put(feed.getInsteadReceiptVoucher(), sapBatch);
        });
    }

    private void confirmSuccess(String code, List<ZSRMDSHRFCRETPZ> pzLists, Map<String, String> sapBacthMap) {
        ZSRMDSHRFCRETPZ pz = pzLists.get(0);
        BAPI2017GMHEADRET doc = pz.getBAPIRET();
        OemFeed feed = new OemFeed();
        feed.setConfirmDate(new Date());
        feed.setBwart(pz.getBWART());
        feed.setDocyear(doc.getDOCYEAR());
        feed.setSapReceiptVoucher(doc.getMATDOC());
        feed.setConfirmFailReason(" ");
        feed.setConfirmStatus(OemConfirmStatusEnum.COLLECTED.getValue());
        feed.setSapBatchNumber(sapBacthMap.get(code));
        OemFeedExample example = new OemFeedExample();
        example.createCriteria().andInsteadReceiptVoucherEqualTo(code);
        OemContextUtils.getOemFeedService().modifybyExample(feed, example);
    }

    private void confirmFail(String code, String msg) {
        OemFeed feed = new OemFeed();
        feed.setConfirmStatus(OemConfirmStatusEnum.COLLECTED_FAIL.getValue());
        feed.setConfirmFailReason(msg);
        OemFeedExample example = new OemFeedExample();
        example.createCriteria().andInsteadReceiptVoucherEqualTo(code);
        OemContextUtils.getOemFeedService().modifybyExample(feed, example);
    }

    private ZSRMRFCJGLDSRKResponse getDataFromSap(List<OemFeed> oemFeeds) {
        log.debug("\u3010\u7532\u4f9b\u6599\u56de\u5199SAP\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(oemFeeds);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u7532\u4f9b\u6599\u56de\u5199SAP\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010\u7532\u4f9b\u6599\u56de\u5199SAP\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCJGLDSRKResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u7532\u4f9b\u6599\u56de\u5199SAP\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error("--> http status {}", (Object)vo.getStatus());
            log.error("--> ReasonPhrase {}", (Object)vo.getReasonPhrase());
            log.error("--> error {}", (Object)vo.getError());
            throw new CommonException("500 SAP Internal Server Error");
        }
        log.debug("\u3010\u7532\u4f9b\u6599\u56de\u5199SAP\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCJGLDSRKResponse respone = (ZSRMRFCJGLDSRKResponse)vo.getResult();
        if (respone == null) {
            throw new CommonException("\u7532\u4f9b\u6599\u56de\u5199SAP,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        log.info("\u3010\u7532\u4f9b\u6599\u56de\u5199SAP\u30111.\u83b7\u53d6\u5230\u6570\u636e");
        return respone;
    }

    private String getXmlParams(List<OemFeed> oemFeeds) {
        StringBuffer dsh01 = new StringBuffer();
        dsh01.append(" <IT_DSH01>");
        oemFeeds.stream().forEach(feed -> {
            dsh01.append(" <item>");
            dsh01.append(" <ZDSHPZ>" + feed.getInsteadReceiptVoucher() + "</ZDSHPZ>");
            dsh01.append(" <BUDAT>" + DateFormatUtils.format((Date)feed.getInsteadReceiptDate(), (String)"yyyy-MM-dd") + "</BUDAT>");
            dsh01.append(" <WERKS>" + feed.getFactory() + "</WERKS>");
            dsh01.append(" <LIFNR>" + feed.getSupCompanySapCode() + "</LIFNR>");
            dsh01.append(" <BKTXT>" + feed.getRemark() + "</BKTXT>");
            dsh01.append("  </item>");
        });
        dsh01.append(" </IT_DSH01>");
        StringBuffer dsh02 = new StringBuffer();
        dsh02.append(" <IT_DSH02>");
        oemFeeds.stream().forEach(feed -> {
            dsh02.append(" <item>");
            dsh02.append(" <ZDSHPZ>" + feed.getInsteadReceiptVoucher() + "</ZDSHPZ>");
            dsh02.append("  <ZDSHHH>" + feed.getReceiptVoucherIitemNo() + "</ZDSHHH>");
            dsh02.append(" <EBELN>0" + feed.getOrderNo() + "</EBELN>");
            dsh02.append(" <EBELP>" + feed.getOrderItemNo() + "</EBELP>");
            dsh02.append("  <BSART>" + this.getOrderType(feed.getOrderNo()) + "</BSART>");
            dsh02.append("  <MATNR>" + PAT.substring(0, PAT.length() - feed.getMaterialCode().length()) + feed.getMaterialCode() + "</MATNR>");
            dsh02.append(" <MENGE>" + feed.getReceivedQuantity() + "</MENGE>");
            dsh02.append(" <MEINS>" + feed.getOrderUnit() + "</MEINS>");
            dsh02.append(" <BUDAT>" + DateFormatUtils.format((Date)feed.getCreateTime(), (String)"yyyy-MM-dd") + "</BUDAT>");
            if (feed.getWarehouseName() != null && feed.getWarehouseName().length() < 0 && feed.getWarehouseName().length() <= 4) {
                dsh02.append(" <UMLGO>" + (feed.getWarehouseName() == null ? "" : feed.getWarehouseName()) + "</UMLGO>");
            }
            dsh02.append(" <CHARG>" + feed.getSapBatchNumber() + "</CHARG>");
            dsh02.append(" <FHDNO>" + feed.getDeliveryOrderNo() + "</FHDNO>");
            dsh02.append(" <FHDHH>" + (feed.getDeliveryOrderItemNo() == null ? "" : feed.getDeliveryOrderItemNo()) + "</FHDHH>");
            dsh02.append(" <LGORT>" + (feed.getWarehouseLocation() == null ? "" : feed.getWarehouseLocation()) + "</LGORT>");
            dsh02.append(" </item>");
        });
        dsh02.append(" </IT_DSH02>");
        dsh01.append(dsh02);
        return dsh01.toString();
    }

    private String getOrderType(String orderNo) {
        PurchaseOrder order = OemContextUtils.getPurchaseOrderService().queryByOrderNo(ProjectUtils.getProjectId(), orderNo);
        if (order == null) {
            return null;
        }
        return order.getOrderType();
    }
}

