/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.feed.entity.OemFeedOrderItemExt;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.util.GetVoucherNoUtil;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class CreateFeedInsteadCommand
extends AbstractCommand<List<OemFeed>> {
    private OemFeed oemFeed;

    public CreateFeedInsteadCommand(OemFeed oemFeed) {
        this.oemFeed = oemFeed;
    }

    public List<OemFeed> execute(ICommandInvoker context) {
        BigDecimal deliveryQuantity = this.oemFeed.getBatchNumberList().stream().map(b -> b.getReceivedQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
        PurchaseOrderItem purchaseOrderItem = OemOrderItemUtils.vaidOrderstatus(this.oemFeed.getOrderNo(), this.oemFeed.getOrderItemId(), deliveryQuantity);
        this.initOther(this.oemFeed, purchaseOrderItem);
        this.vaidRequire(this.oemFeed);
        List<OemFeed> lists = this.init(this.oemFeed);
        OemContextUtils.getOemFeedService().addAll(lists);
        this.addOemOrderItemExt(this.oemFeed);
        return lists;
    }

    private void addOemOrderItemExt(OemFeed o) {
        BigDecimal deliveryQuantity = this.oemFeed.getBatchNumberList().stream().map(b -> b.getReceivedQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
        OemFeedOrderItemExt oemOrderItemExt = OemContextUtils.getOemFeedOrderItemExtService().queryByItemId(o.getOrderItemId());
        if (oemOrderItemExt != null) {
            OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(o.getOrderItemId(), deliveryQuantity);
        } else {
            OemFeedOrderItemExt ext = new OemFeedOrderItemExt();
            ext.setOrderId(o.getOrderId());
            ext.setOrderNo(o.getOrderNo());
            ext.setOrderItemId(o.getOrderItemId());
            ext.setOrderItemNo(o.getOrderItemNo());
            ext.setUnsubmittedQuantity(deliveryQuantity);
            ext.setSubmittedQuantity(BigDecimal.ZERO);
            ext.setWriteOffQuantity(BigDecimal.ZERO);
            ext.setReturnBackQuantity(BigDecimal.ZERO);
            ext.setReceivedQuantity(BigDecimal.ZERO);
            OemContextUtils.getOemFeedOrderItemExtService().addObj(ext);
        }
    }

    private void initOther(OemFeed oemFeed, PurchaseOrderItem purchaseOrderItem) {
        oemFeed.setSupCompanySapId(purchaseOrderItem.getSupCompanyId());
        oemFeed.setSupCompanySapCode(purchaseOrderItem.getSupCompanySapCode());
        oemFeed.setSupCompanyName(purchaseOrderItem.getSupCompanyName());
        oemFeed.setQuantity(purchaseOrderItem.getQuantity());
        oemFeed.setOrderUnit(purchaseOrderItem.getOrderUnit());
        oemFeed.setWarehouseLocation(purchaseOrderItem.getWarehouseLocation());
        oemFeed.setDeliveredDate(purchaseOrderItem.getDeliveredDate());
    }

    private void vaidRequire(OemFeed oemFeed) {
        Assert.isNotBlank((String)oemFeed.getDeliveryOrderNo(), (String)"\u9001\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(oemFeed.getBatchNumberList(), (String)"\u6279\u6b21\u53f7\u548c\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        oemFeed.getBatchNumberList().stream().forEach(batchNumberList -> {
            Assert.isNotBlank((String)batchNumberList.getBatchNumber(), (String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)batchNumberList.getReceivedQuantity().toString(), (String)"\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        });
        Assert.isNotBlank((String)oemFeed.getFileId(), (String)"\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getOrderNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getOrderItemNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getOrderItemId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private List<OemFeed> init(OemFeed oemFeed) {
        if (oemFeed.getInsteadReceiptDate() == null) {
            oemFeed.setInsteadReceiptDate(new Date());
        }
        this.oemFeed.setReceiptVoucherIitemNo("1");
        this.oemFeed.setSendStatus(OemSendStatusEnum.UNSUBMITTED.getValue());
        this.oemFeed.setConfirmStatus(OemConfirmStatusEnum.UNCOLLECTED.getValue());
        this.oemFeed.setWriteOffFlag(OemWriteOffEnum.UN_WRITE_OFF.getValue());
        this.oemFeed.setCreateUserId(this.getSupUser().getId());
        this.oemFeed.setCreateUserName(this.getSupUser().getNickName());
        this.oemFeed.setCreateTime(new Date());
        PurchaseOrder purOrder = OemContextUtils.getPurchaseOrderService().queryByOrderNo(ProjectUtils.getProjectId(), this.oemFeed.getOrderNo());
        this.oemFeed.setOrderType(purOrder.getOrderType());
        List<OemFeed> lists = oemFeed.getBatchNumberList().stream().map(batchNumberList -> {
            this.oemFeed.setId(UUIDGenerator.generateUUID());
            this.oemFeed.setBatchNumber(batchNumberList.getBatchNumber());
            this.oemFeed.setReceivedQuantity(batchNumberList.getReceivedQuantity());
            this.oemFeed.setInsteadReceiptVoucher(GetVoucherNoUtil.getFeedVoucher(this.oemFeed.getFactory()));
            OemFeed instead = new OemFeed();
            BeanUtils.copyProperties((Object)this.oemFeed, (Object)instead);
            return instead;
        }).collect(Collectors.toList());
        return lists;
    }
}

