/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.delivery.entity.PurVoucher;
import com.els.base.purchase.command.order.UpdateReceiveQuantityCommand;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemWriteOffEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FeedWriteOffByAspCommand
extends AbstractCommand {
    private Date startTime;
    private Date endTime;

    public FeedWriteOffByAspCommand(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Object execute(ICommandInvoker context) {
        List<PurVoucher> purVouchers = OemOrderItemUtils.getSapWriteOffVoucherNos(this.startTime, this.endTime);
        ArrayList<String> orderItemIds = new ArrayList<String>();
        for (PurVoucher voucher : purVouchers) {
            String orderItemId = this.writeOffFeed(voucher);
            if (!StringUtils.isNotBlank((String)orderItemId)) continue;
            orderItemIds.add(orderItemId);
        }
        if (CollectionUtils.isNotEmpty(orderItemIds)) {
            PurchaseOrderItemExample example = new PurchaseOrderItemExample();
            example.createCriteria().andIdIn(orderItemIds);
            List lists = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
            UpdateReceiveQuantityCommand command = new UpdateReceiveQuantityCommand(lists);
            context.invoke((AbstractCommand)command);
        }
        return null;
    }

    private String writeOffFeed(PurVoucher voucher) {
        if (StringUtils.isNotBlank((String)voucher.getMaterialVoucherNo())) {
            OemContextUtils.getOemFeedService().writeOffBySap(OemWriteOffEnum.SAP_WRITE_OFF.getValue(), voucher.getMaterialVoucherNo(), voucher.getVoucherTime());
            OemFeed feed = OemContextUtils.getOemFeedService().queryObjByInsteadVoucher(voucher.getMaterialVoucherNo());
            return feed.getOrderItemId();
        }
        return null;
    }
}

