/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import java.math.BigDecimal;

public class ModifyFeedInsteadCommand
extends AbstractCommand {
    private OemFeed oemFeed;

    public ModifyFeedInsteadCommand(OemFeed oemFeed) {
        this.oemFeed = oemFeed;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemFeed);
        this.vaidOrderStatus(this.oemFeed);
        this.vaidRequire(this.oemFeed);
        this.oemFeed.setSendStatus(OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue());
        OemContextUtils.getOemFeedService().modifyObj(this.oemFeed);
        OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(this.oemFeed.getOrderItemId(), this.oemFeed.getReceivedQuantity());
        return null;
    }

    private void vaidOrderStatus(OemFeed oemFeed) {
        OemFeed feed = (OemFeed)OemContextUtils.getOemFeedService().queryObjById(oemFeed.getId());
        if (OemSendStatusEnum.UNSUBMITTED.getValue() == oemFeed.getSendStatus().intValue() || OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue() == oemFeed.getSendStatus().intValue()) {
            OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(feed.getOrderItemId(), BigDecimal.ZERO.subtract(feed.getReceivedQuantity()));
        } else if (OemConfirmStatusEnum.RETURN_BACK.getValue() == oemFeed.getConfirmStatus().intValue()) {
            OemContextUtils.getOemFeedOrderItemExtService().addReturnQuantity(feed.getOrderItemId(), BigDecimal.ZERO.subtract(feed.getReceivedQuantity()));
        } else if (OemConfirmStatusEnum.COLLECTED_FAIL.getValue() == oemFeed.getConfirmStatus().intValue()) {
            OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(feed.getOrderItemId(), BigDecimal.ZERO.subtract(feed.getReceivedQuantity()));
        }
        OemOrderItemUtils.vaidOrderstatus(this.oemFeed.getOrderNo(), this.oemFeed.getOrderItemId(), oemFeed.getReceivedQuantity());
    }

    private void vaidRequire(OemFeed oemFeed) {
        Assert.isNotBlank((String)oemFeed.getDeliveryOrderNo(), (String)"\u9001\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getBatchNumber(), (String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getReceivedQuantity().toString(), (String)"\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getFileId(), (String)"\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getOrderNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getOrderItemNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemFeed.getOrderItemId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void vaidStatus(OemFeed o) {
        if ("Y".equals(o.getWriteOffFlag())) {
            throw new CommonException("\u4fee\u6539\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u5df2\u51b2\u9500");
        }
        if (OemConfirmStatusEnum.RETURN_BACK.getValue() != o.getConfirmStatus().intValue() && OemConfirmStatusEnum.COLLECTED_FAIL.getValue() != o.getConfirmStatus().intValue() && Constant.YES_INT.equals(o.getSendStatus())) {
            throw new CommonException("\u4fee\u6539\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u5df2\u53d1\u9001");
        }
    }
}

