/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.liby.collection.command.ModifyOemOrderItemCanDeliveryCmd;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.feed.entity.OemFeedExample;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ReturnBackCommand
extends AbstractCommand {
    private List<OemFeed> oemFeeds;

    public ReturnBackCommand(List<OemFeed> oemFeeds) {
        this.oemFeeds = oemFeeds;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemFeeds);
        this.saveReturnBackQuantity(this.oemFeeds);
        List ids = this.oemFeeds.stream().map(o -> o.getId()).collect(Collectors.toList());
        OemFeed instead = new OemFeed();
        instead.setConfirmStatus(OemConfirmStatusEnum.RETURN_BACK.getValue());
        instead.setReturnDate(new Date());
        OemFeedExample example = new OemFeedExample();
        example.createCriteria().andIdIn(ids);
        OemContextUtils.getOemFeedService().modifybyExample(instead, example);
        List<String> itemIds = this.oemFeeds.stream().map(o -> o.getOrderItemId()).collect(Collectors.toList());
        ModifyOemOrderItemCanDeliveryCmd cmd = new ModifyOemOrderItemCanDeliveryCmd(itemIds);
        context.invoke((AbstractCommand)cmd);
        return null;
    }

    private void vaidStatus(List<OemFeed> oemFeeds) {
        oemFeeds.stream().forEach(o -> {
            if (OemConfirmStatusEnum.RETURN_BACK.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u5df2\u62d2\u6536");
            }
            if (OemConfirmStatusEnum.COLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u5df2\u786e\u8ba4");
            }
            if (OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue() == o.getSendStatus().intValue() || OemSendStatusEnum.UNSUBMITTED.getValue() == o.getSendStatus().intValue()) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u672a\u63d0\u4ea4");
            }
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(o.getWriteOffFlag())) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u5df2\u51b2\u9500");
            }
        });
    }

    private void saveReturnBackQuantity(List<OemFeed> oemFeeds) {
        oemFeeds.stream().forEach(o -> {
            OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            OemContextUtils.getOemFeedOrderItemExtService().addReturnQuantity(o.getOrderItemId(), o.getReceivedQuantity());
        });
    }
}

