/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.liby.collection.command.ModifyOemOrderItemCanDeliveryCmd;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.feed.entity.OemFeedExample;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class WriteOffCommand
extends AbstractCommand {
    private List<OemFeed> oemFeeds;

    public WriteOffCommand(List<OemFeed> oemFeeds) {
        this.oemFeeds = oemFeeds;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemFeeds);
        this.saveWriteOffQuantity(this.oemFeeds);
        OemFeedExample example = new OemFeedExample();
        List ids = this.oemFeeds.stream().map(o -> o.getId()).collect(Collectors.toList());
        OemFeed instead = new OemFeed();
        instead.setWriteOffFlag(OemWriteOffEnum.SRM_WRITE_OFF.getValue());
        instead.setWriteOffDate(new Date());
        example.clear();
        example.createCriteria().andIdIn(ids);
        OemContextUtils.getOemFeedService().modifybyExample(instead, example);
        List<String> itemIds = this.oemFeeds.stream().map(o -> o.getOrderItemId()).collect(Collectors.toList());
        ModifyOemOrderItemCanDeliveryCmd cmd = new ModifyOemOrderItemCanDeliveryCmd(itemIds);
        context.invoke((AbstractCommand)cmd);
        return null;
    }

    private void vaidStatus(List<OemFeed> oemFeeds) {
        oemFeeds.stream().forEach(o -> {
            if (OemConfirmStatusEnum.COLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u51b2\u9500\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u5df2\u786e\u8ba4");
            }
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(o.getWriteOffFlag())) {
                throw new CommonException("\u51b2\u9500\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadReceiptVoucher() + "\uff1b\u5df2\u51b2\u9500");
            }
            if (OemSendStatusEnum.SUBMITTED.getValue() == o.getSendStatus().intValue() && OemConfirmStatusEnum.UNCOLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u51b2\u9500\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u53d1\u9001\uff0c\u4e14\u672a\u786e\u8ba4");
            }
        });
    }

    private void saveWriteOffQuantity(List<OemFeed> oemFeeds) {
        oemFeeds.stream().forEach(o -> {
            if (OemConfirmStatusEnum.RETURN_BACK.getValue() == o.getConfirmStatus().intValue() && OemSendStatusEnum.SUBMITTED.getValue() == o.getSendStatus().intValue()) {
                OemContextUtils.getOemFeedOrderItemExtService().addReturnQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            } else if (OemConfirmStatusEnum.COLLECTED_FAIL.getValue() == o.getConfirmStatus().intValue() && OemSendStatusEnum.SUBMITTED.getValue() == o.getSendStatus().intValue()) {
                OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            } else if (OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue() == o.getSendStatus().intValue() || OemSendStatusEnum.UNSUBMITTED.getValue() == o.getSendStatus().intValue()) {
                OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            }
            OemContextUtils.getOemFeedOrderItemExtService().addWriteOffQuantity(o.getOrderItemId(), o.getReceivedQuantity());
        });
    }
}

