/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.liby.collection.command.ViewOemInsteadOrderCommand;
import com.els.liby.collection.command.ViewOemOrderCommand;
import com.els.liby.collection.feed.command.BatchCreateFeedInsteadCmd;
import com.els.liby.collection.feed.command.CollectedCommand;
import com.els.liby.collection.feed.command.CreateAndSendFeedInsteadCmd;
import com.els.liby.collection.feed.command.ModifyFeedInsteadCommand;
import com.els.liby.collection.feed.command.ReturnBackCommand;
import com.els.liby.collection.feed.command.SendCommand;
import com.els.liby.collection.feed.command.WriteOffCommand;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.feed.entity.OemFeedExample;
import com.els.liby.collection.feed.service.OemFeedService;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.collection.utils.OemOrderItems;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7532\u4f9b\u7269\u6599\u91c7\u8d2d")
@Controller
@RequestMapping(value={"oemInstead"})
public class OemInsteadController {
    @Resource
    protected OemFeedService oemFeedService;
    @Resource
    protected PurchaseOrderService purchaseOrderHeaderService;
    @Resource
    protected OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u521b\u5efa\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<OemFeed> oemFeeds) {
        BatchCreateFeedInsteadCmd command = new BatchCreateFeedInsteadCmd(oemFeeds);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody OemFeed oemFeed) {
        Assert.isNotBlank((String)oemFeed.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyFeedInsteadCommand command = new ModifyFeedInsteadCommand(oemFeed);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        OemFeedExample example = new OemFeedExample();
        example.createCriteria().andIdIn((List)ids);
        this.oemFeedService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4ee3\u6536\u8d27\u51ed\u8bc1\u7ba1\u7406\uff08\u91c7\u8d2d\u65b9\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemFeed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemFeed>> purfindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemFeedExample example = new OemFeedExample();
        example.setPageView((PageView<OemFeed>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC");
        OemFeedExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemFeedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4ee3\u5904\u7406\u4ee3\u6536\u8d27\u51ed\u8bc1\u7ba1\u7406\uff08\u91c7\u8d2d\u65b9\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemFeed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findUntreatedByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemFeed>> findUnCollectedByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemFeedExample example = new OemFeedExample();
        example.setPageView((PageView<OemFeed>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC");
        OemFeedExample.Criteria criteria = example.createCriteria();
        criteria.andConfirmStatusIn((List)Arrays.asList(OemConfirmStatusEnum.UNCOLLECTED.getValue(), OemConfirmStatusEnum.COLLECTED_FAIL.getValue())).andConfirmStatusEqualTo(OemConfirmStatusEnum.UNCOLLECTED.getValue()).andWriteOffFlagEqualTo(OemWriteOffEnum.UN_WRITE_OFF.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemFeedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4ee3\u6536\u8d27\u51ed\u8bc1\u7ba1\u7406\uff08\u4f9b\u5e94\u5546\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemFeed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemFeed>> supfindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemFeedExample example = new OemFeedExample();
        example.setPageView((PageView<OemFeed>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC");
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        OemFeedExample.Criteria criteria = example.createCriteria();
        criteria.andFactoryIn((List)oemFactorys);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemFeedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5f85\u5904\u7406\u4ee3\u6536\u8d27\u51ed\u8bc1\u7ba1\u7406\uff08\u4f9b\u5e94\u5546\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemFeed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findUntreatedByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemFeed>> findUnsbumitByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemFeedExample example = new OemFeedExample();
        example.setPageView((PageView<OemFeed>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC");
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        OemFeedExample.Criteria criteria = example.createCriteria();
        criteria.andSendStatusNotEqualTo(OemSendStatusEnum.SUBMITTED.getValue()).andWriteOffFlagEqualTo(OemWriteOffEnum.UN_WRITE_OFF.getValue()).andFactoryIn((List)oemFactorys);
        example.or().andConfirmStatusIn((List)Arrays.asList(OemConfirmStatusEnum.RETURN_BACK.getValue(), OemConfirmStatusEnum.COLLECTED_FAIL.getValue())).andWriteOffFlagEqualTo(OemWriteOffEnum.UN_WRITE_OFF.getValue()).andFactoryIn((List)oemFactorys);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemFeedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee3\u6536\u8d27\u7532\u4f9b\u7269\u6599\u91c7\u8d2d\u8ba2\u5355", httpMethod="POST")
    @RequestMapping(value={"service/findInsteadFeedOrder"})
    @ResponseBody
    public ResponseResult<OemOrderItems> findInsteadFeedOrder(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List<String> types = Arrays.asList("C200", "Z200", "C100", "Z100");
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        ViewOemInsteadOrderCommand cmd = new ViewOemInsteadOrderCommand(types, oemFactorys, wapper);
        return ResponseResult.success((Object)this.invoker.invoke((AbstractCommand)cmd));
    }

    @ApiOperation(value="\u67e5\u8be2\u7532\u4f9b\u7269\u6599\u91c7\u8d2d\u8ba2\u5355", httpMethod="POST")
    @RequestMapping(value={"service/findReedOrder"})
    @ResponseBody
    public ResponseResult<OemOrderItems> findReedOrder(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List<String> types = Arrays.asList("C200", "Z200", "C100", "Z100");
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        ViewOemOrderCommand cmd = new ViewOemOrderCommand(types, oemFactorys, wapper);
        return ResponseResult.success((Object)this.invoker.invoke((AbstractCommand)cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4")
    @RequestMapping(value={"service/submitByIds"})
    @ResponseBody
    public ResponseResult<String> submitByIds(@RequestBody(required=true) List<OemFeed> oemFeeds) {
        Assert.isNotEmpty(oemFeeds, (String)"\u63d0\u4ea4\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        SendCommand command = new SendCommand(oemFeeds);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u786e\u8ba4")
    @RequestMapping(value={"service/collectedByIds"})
    @ResponseBody
    public ResponseResult<String> collectedByIds(@RequestBody(required=true) List<OemFeed> oemFeeds) {
        Assert.isNotEmpty(oemFeeds, (String)"\u786e\u8ba4\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        CollectedCommand command = new CollectedCommand(oemFeeds);
        List results = (List)this.invoker.invoke((AbstractCommand)command);
        Assert.isNotEmpty((Collection)results, (String)"\u786e\u8ba4\u5931\u8d25");
        if (oemFeeds.size() > 1) {
            if (results.size() < oemFeeds.size()) {
                return ResponseResult.success((Object)("\u90e8\u5206\u786e\u8ba4\u6210\u529f\uff0c\u6210\u529f\uff1a" + results.size() + "\u6761\uff0c\u5931\u8d25\uff1a" + (oemFeeds.size() - results.size())));
            }
        } else if (results.size() != 1) {
            return new ResponseResult(ResponseCode.Fail.getCode(), "\u786e\u8ba4\u5931\u8d25", null);
        }
        return ResponseResult.success((Object)"\u786e\u8ba4\u6210\u529f");
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u62d2\u6536")
    @RequestMapping(value={"service/returnBackByIds"})
    @ResponseBody
    public ResponseResult<String> returnBackByIds(@RequestBody(required=true) List<OemFeed> oemFeeds) {
        Assert.isNotEmpty(oemFeeds, (String)"\u62d2\u6536\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        ReturnBackCommand command = new ReturnBackCommand(oemFeeds);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u51b2\u9500")
    @RequestMapping(value={"service/WriteOffByIds"})
    @ResponseBody
    public ResponseResult<String> WriteOffByIds(@RequestBody(required=true) List<OemFeed> oemFeeds) {
        Assert.isNotEmpty(oemFeeds, (String)"\u51b2\u9500\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        WriteOffCommand command = new WriteOffCommand(oemFeeds);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4e14\u53d1\u9001\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/createAndSend"})
    @ResponseBody
    public ResponseResult<String> createAndSend(@RequestBody List<OemFeed> oemFeeds) {
        CreateAndSendFeedInsteadCmd command = new CreateAndSendFeedInsteadCmd(oemFeeds);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }
}

