/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.collection.feed.dao.OemFeedOrderItemExtMapper;
import com.els.liby.collection.feed.entity.OemFeedOrderItem;
import com.els.liby.collection.feed.entity.OemFeedOrderItemExt;
import com.els.liby.collection.feed.entity.OemFeedOrderItemExtExample;
import com.els.liby.collection.feed.service.OemFeedOrderItemExtService;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemFeedOrderItemExtService")
public class OemFeedOrderItemExtServiceImpl
implements OemFeedOrderItemExtService {
    @Resource
    protected OemFeedOrderItemExtMapper oemFeedOrderItemExtMapper;

    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void addObj(OemFeedOrderItemExt t) {
        this.oemFeedOrderItemExtMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void addAll(List<OemFeedOrderItemExt> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemFeedOrderItemExtMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemFeedOrderItemExtMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void deleteByExample(OemFeedOrderItemExtExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemFeedOrderItemExtMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void modifyObj(OemFeedOrderItemExt t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemFeedOrderItemExtMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemFeedOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public OemFeedOrderItemExt queryObjById(String id) {
        return this.oemFeedOrderItemExtMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemFeedOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public List<OemFeedOrderItemExt> queryAllObjByExample(OemFeedOrderItemExtExample example) {
        return this.oemFeedOrderItemExtMapper.selectByExample(example);
    }

    @Cacheable(value={"oemFeedOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public PageView<OemFeedOrderItemExt> queryObjByPage(OemFeedOrderItemExtExample example) {
        PageView<OemFeedOrderItemExt> pageView = example.getPageView();
        pageView.setQueryResult(this.oemFeedOrderItemExtMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"oemFeedOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public OemFeedOrderItemExt queryByItemId(String itemId) {
        OemFeedOrderItemExtExample example = new OemFeedOrderItemExtExample();
        example.createCriteria().andOrderItemIdEqualTo(itemId);
        List<OemFeedOrderItemExt> list = this.oemFeedOrderItemExtMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u7684\u6536\u8d27/\u53d1\u8d27\u62d3\u5c55\u4fe1\u606f\u51fa\u73b0\u91cd\u590d");
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void addSubmittedQuantity(String orderItemId, BigDecimal quantity) {
        this.oemFeedOrderItemExtMapper.addSubmittedQuantity(orderItemId, quantity);
    }

    @Override
    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void addUnsubmittedQuantity(String orderItemId, BigDecimal quantity) {
        this.oemFeedOrderItemExtMapper.addUnsubmittedQuantity(orderItemId, quantity);
    }

    @Override
    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void addReceivedQuantity(String orderItemId, BigDecimal quantity) {
        this.oemFeedOrderItemExtMapper.addReceivedQuantity(orderItemId, quantity);
    }

    @Override
    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void addReturnQuantity(String orderItemId, BigDecimal quantity) {
        this.oemFeedOrderItemExtMapper.addReturnQuantity(orderItemId, quantity);
    }

    @Override
    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public void addWriteOffQuantity(String orderItemId, BigDecimal quantity) {
        this.oemFeedOrderItemExtMapper.addWriteOffQuantity(orderItemId, quantity);
    }

    @Override
    @CacheEvict(value={"oemFeedOrderItemExt"}, allEntries=true)
    public List<OemFeedOrderItem> selectInsteadByExample(PurchaseOrderItemExample example) {
        return this.oemFeedOrderItemExtMapper.selectInsteadByExample(example);
    }
}

