/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.feed.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.collection.feed.dao.OemFeedMapper;
import com.els.liby.collection.feed.entity.OemFeed;
import com.els.liby.collection.feed.entity.OemFeedExample;
import com.els.liby.collection.feed.service.OemFeedService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemFeedService")
public class OemFeedServiceImpl
implements OemFeedService {
    @Resource
    protected OemFeedMapper oemFeedMapper;

    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public void addObj(OemFeed t) {
        this.oemFeedMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public void addAll(List<OemFeed> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemFeedMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemFeedMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public void deleteByExample(OemFeedExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemFeedMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public void modifyObj(OemFeed t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemFeedMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemFeed"}, keyGenerator="redisKeyGenerator")
    public OemFeed queryObjById(String id) {
        return this.oemFeedMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemFeed"}, keyGenerator="redisKeyGenerator")
    public List<OemFeed> queryAllObjByExample(OemFeedExample example) {
        return this.oemFeedMapper.selectByExample(example);
    }

    @Cacheable(value={"oemFeed"}, keyGenerator="redisKeyGenerator")
    public PageView<OemFeed> queryObjByPage(OemFeedExample example) {
        PageView<OemFeed> pageView = example.getPageView();
        pageView.setQueryResult(this.oemFeedMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public void modifybyExample(OemFeed instead, OemFeedExample example) {
        this.oemFeedMapper.updateByExampleSelective(instead, example);
    }

    @Override
    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public OemFeed getMaxCodeOemFeed(String code) {
        OemFeedExample example = new OemFeedExample();
        example.setOrderByClause(" CREATE_TIME DESC");
        example.createCriteria().andInsteadReceiptVoucherLike(code + "%");
        List<OemFeed> lists = this.oemFeedMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(lists)) {
            return lists.get(0);
        }
        return null;
    }

    @Override
    @Cacheable(value={"oemFeed"}, keyGenerator="redisKeyGenerator")
    public OemFeed queryObjByInsteadVoucher(String voucherNo) {
        OemFeedExample example = new OemFeedExample();
        example.createCriteria().andInsteadReceiptVoucherEqualTo(voucherNo);
        List<OemFeed> lists = this.oemFeedMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(lists)) {
            return lists.get(0);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"oemFeed"}, allEntries=true)
    public void writeOffBySap(String status, String sapReceiptVoucher, Date writeOffDate) {
        this.oemFeedMapper.writeOffBySap(status, sapReceiptVoucher, writeOffDate);
    }
}

