/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.oem.entity.OemOrderInsteadExample;
import com.els.liby.collection.oem.sap.order.BAPI2017GMHEADRET;
import com.els.liby.collection.oem.sap.order.ZSRMDSHRFCRET;
import com.els.liby.collection.oem.sap.order.ZSRMDSHRFCRETPZ;
import com.els.liby.collection.oem.sap.order.ZSRMRFCOEMDSRKResponse;
import com.els.liby.quota.service.SoapServiceRequestText;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectedBackSapCommand
extends AbstractCommand<List<String>> {
    private static final Logger log = LoggerFactory.getLogger(CollectedBackSapCommand.class);
    private static String username = OemSapConfUtils.getServiceUsername();
    private static String password = OemSapConfUtils.getServicePassword();
    private static String serviceUrl = OemSapConfUtils.getOemInsteadUrl();
    private static String serviceNameSpace = OemSapConfUtils.getNameSpace();
    private static String serviceMethod = OemSapConfUtils.getOemInsteadServiceMethod();
    private List<OemOrderInstead> oemOrderInsteads;

    public CollectedBackSapCommand(List<OemOrderInstead> oemOrderInsteads) {
        this.oemOrderInsteads = oemOrderInsteads;
    }

    public List<String> execute(ICommandInvoker context) {
        ZSRMRFCOEMDSRKResponse response = this.getDataFromSap(this.oemOrderInsteads);
        List<ZSRMDSHRFCRET> lists = response.getETINFO().getItem();
        Assert.isNotEmpty(lists, (String)"SAP\u751f\u6210\u51ed\u8bc1\u5931\u8d25");
        List<String> VoucherCodes = lists.stream().map(z -> {
            String code = z.getZDSHPZ();
            if ("S".equals(z.getTYPE())) {
                this.confirmSuccess(code, z.getPZITEM().getItem());
                return code;
            }
            this.confirmFail(code, z.getMSG());
            return null;
        }).filter(code -> StringUtils.isNotBlank((String)code)).collect(Collectors.toList());
        return VoucherCodes;
    }

    private void confirmSuccess(String code, List<ZSRMDSHRFCRETPZ> pzLists) {
        List voucher = pzLists.stream().filter(p -> "101".equals(p.getBWART())).collect(Collectors.toList());
        ZSRMDSHRFCRETPZ pz = (ZSRMDSHRFCRETPZ)voucher.get(0);
        BAPI2017GMHEADRET doc = pz.getBAPIRET();
        OemOrderInstead instead = new OemOrderInstead();
        instead.setConfirmDate(new Date());
        instead.setBwart(pz.getBWART());
        instead.setDocyear(doc.getDOCYEAR());
        instead.setSapReceiptVoucher(doc.getMATDOC());
        instead.setConfirmFailReason("\u65e0");
        instead.setConfirmStatus(OemConfirmStatusEnum.COLLECTED.getValue());
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.createCriteria().andInsteadReceiptVoucherEqualTo(code);
        OemContextUtils.getOemOrderInsteadService().modifybyExample(instead, example);
    }

    private void confirmFail(String code, String msg) {
        OemOrderInstead instead = new OemOrderInstead();
        instead.setConfirmStatus(OemConfirmStatusEnum.COLLECTED_FAIL.getValue());
        instead.setConfirmFailReason(msg);
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.createCriteria().andInsteadReceiptVoucherEqualTo(code);
        OemContextUtils.getOemOrderInsteadService().modifybyExample(instead, example);
    }

    private ZSRMRFCOEMDSRKResponse getDataFromSap(List<OemOrderInstead> oemOrderInsteads) {
        log.debug("\u3010OEM\u786e\u8ba4\u56de\u5199SAP\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(oemOrderInsteads);
        request.setXmlParams(xmlParams);
        log.debug("\u3010OEM\u786e\u8ba4\u56de\u5199SAP\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010OEM\u786e\u8ba4\u56de\u5199SAP\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCOEMDSRKResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010OEM\u786e\u8ba4\u56de\u5199SAP\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            throw new CommonException("OEM\u786e\u8ba4\u56de\u5199SAP\u63a5\u53e3\u5f02\u5e38");
        }
        log.debug("\u3010OEM\u786e\u8ba4\u56de\u5199SAP\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCOEMDSRKResponse respone = (ZSRMRFCOEMDSRKResponse)vo.getResult();
        if (respone == null) {
            throw new CommonException("\u7532\u4f9b\u6599\u56de\u5199SAP,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        log.info("\u3010OEM\u786e\u8ba4\u56de\u5199SAP\u30111.\u83b7\u53d6\u5230\u6570\u636e");
        return respone;
    }

    private String getXmlParams(List<OemOrderInstead> oemOrderInsteads) {
        StringBuffer sb = new StringBuffer();
        sb.append("<IT_OEMDSH_DATA>");
        oemOrderInsteads.stream().forEach(o -> {
            sb.append(" <item>");
            sb.append(" <ZDSHPZ>" + o.getInsteadReceiptVoucher() + "</ZDSHPZ>");
            sb.append(" <BUDAT>" + DateFormatUtils.format((Date)o.getInsteadReceiptDate(), (String)"yyyy-MM-dd") + "</BUDAT>");
            sb.append(" <WERKS>" + o.getFactory() + "</WERKS>");
            sb.append(" <LIFNR>" + o.getSupCompanySapCode() + "</LIFNR>");
            sb.append(" <BKTXT>" + o.getRemark() + "</BKTXT>");
            sb.append(" <ITEMDATA>");
            sb.append(" <item>");
            sb.append(" <ZDSHPZ>" + o.getInsteadReceiptVoucher() + "</ZDSHPZ>");
            sb.append("  <ZDSHHH>" + o.getReceiptVoucherIitemNo() + "</ZDSHHH>");
            sb.append(" <EBELN>0" + o.getOrderNo() + "</EBELN>");
            sb.append(" <EBELP>" + o.getOrderItemNo() + "</EBELP>");
            sb.append("  <BSART>" + this.getOrderType(o.getOrderNo()) + "</BSART>");
            sb.append("  <MATNR>" + o.getMaterialCode() + "</MATNR>");
            sb.append(" <MENGE>" + o.getReceivedQuantity() + "</MENGE>");
            sb.append(" <MEINS>" + o.getOrderUnit() + "</MEINS>");
            sb.append(" <BUDAT>" + DateFormatUtils.format((Date)o.getPostingTime(), (String)"yyyy-MM-dd") + "</BUDAT>");
            if (o.getWarehouseName() != null && o.getWarehouseName().length() < 0 && o.getWarehouseName().length() <= 4) {
                sb.append(" <UMLGO>" + (o.getWarehouseName() == null ? "" : o.getWarehouseName()) + "</UMLGO>");
            }
            sb.append(" <CHARG>" + o.getBatchNumber() + "</CHARG>");
            if (StringUtils.isNotBlank((String)o.getDeliveryOrderNo())) {
                sb.append(" <FHDNO>" + o.getDeliveryOrderNo() + "</FHDNO>");
            }
            if (StringUtils.isNotBlank((String)o.getDeliveryOrderItemNo())) {
                sb.append(" <FHDHH>" + o.getDeliveryOrderItemNo() + "</FHDHH>");
            }
            sb.append(" <LGORT>" + (o.getWarehouseLocation() == null ? "" : o.getWarehouseLocation()) + "</LGORT>");
            this.getConsumableDetail(sb, o.getId());
            sb.append(" </item>");
            sb.append(" </ITEMDATA>");
            sb.append(" </item>");
        });
        sb.append("</IT_OEMDSH_DATA>");
        return sb.toString();
    }

    private void getConsumableDetail(StringBuffer sb, String id) {
        List<OemOrderInsteadBatch> lists = OemContextUtils.getOemOrderInsteadBatchService().queryAllObjByInsteadId(id);
        sb.append("  <ETENRDAT>");
        lists.stream().forEach(batch -> {
            sb.append(" <item>");
            sb.append("  <MATNR>" + batch.getMaterialCode() + "</MATNR>");
            sb.append("  <CHARG>" + (StringUtils.isNotBlank((String)batch.getBatchNumber()) ? batch.getBatchNumber() : "") + "</CHARG>");
            sb.append("  <WERKS>" + batch.getFactory() + "</WERKS>");
            sb.append("  <LGORT>" + batch.getStorageLocation() + "</LGORT>");
            sb.append("  <UMWRK>" + batch.getFactory() + "</UMWRK>");
            sb.append("  <SOBKZ>O</SOBKZ>");
            sb.append("  <MEINS>" + (batch.getBomItemUnit() == null ? "" : batch.getBomItemUnit()) + "</MEINS>");
            sb.append("  <MENGE>" + batch.getBatchQuantity() + "</MENGE>");
            sb.append("  </item>");
        });
        sb.append("  </ETENRDAT>");
    }

    private String getOrderType(String orderNo) {
        PurchaseOrder order = OemContextUtils.getPurchaseOrderService().queryByOrderNo(ProjectUtils.getProjectId(), orderNo);
        if (order == null) {
            return null;
        }
        return order.getOrderType();
    }
}

