/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.purchase.command.order.UpdateReceiveQuantityCommand;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.liby.collection.command.ModifyOemOrderItemCanDeliveryCmd;
import com.els.liby.collection.oem.command.CollectedBackSapCommand;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class CollectedCommand
extends AbstractCommand<List<String>> {
    private List<OemOrderInstead> oemOrderInsteads;

    public CollectedCommand(List<OemOrderInstead> oemOrderInsteads) {
        this.oemOrderInsteads = oemOrderInsteads;
    }

    public List<String> execute(ICommandInvoker context) {
        this.vaidStatus(this.oemOrderInsteads);
        CollectedBackSapCommand command = new CollectedBackSapCommand(this.oemOrderInsteads);
        List codes = (List)context.invoke((AbstractCommand)command);
        List<OemOrderInstead> insteads = this.oemOrderInsteads.stream().map(o -> {
            if (codes.contains(o.getInsteadReceiptVoucher())) {
                return o;
            }
            return null;
        }).filter(o -> o != null).collect(Collectors.toList());
        List<String> itemIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(insteads)) {
            this.saveReceivedQuantity(insteads, itemIds);
            itemIds = insteads.stream().map(instead -> instead.getOrderItemId()).collect(Collectors.toList());
            ModifyOemOrderItemCanDeliveryCmd cmd = new ModifyOemOrderItemCanDeliveryCmd(itemIds);
            context.invoke((AbstractCommand)cmd);
        }
        return itemIds;
    }

    private void vaidStatus(List<OemOrderInstead> oemOrderInsteads) {
        oemOrderInsteads.stream().forEach(o -> {
            if (OemConfirmStatusEnum.RETURN_BACK.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u786e\u8ba4\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u62d2\u6536");
            }
            if (OemConfirmStatusEnum.COLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u786e\u8ba4\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u786e\u8ba4");
            }
            if (OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue() == o.getSendStatus().intValue() || OemSendStatusEnum.UNSUBMITTED.getValue() == o.getSendStatus().intValue()) {
                throw new CommonException("\u786e\u8ba4\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u672a\u63d0\u4ea4");
            }
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(o.getWriteOffFlag())) {
                throw new CommonException("\u786e\u8ba4\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u51b2\u9500");
            }
        });
    }

    private void saveReceivedQuantity(List<OemOrderInstead> insteads, List<String> itemIds) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andIdIn(itemIds);
        List lists = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        UpdateReceiveQuantityCommand command = new UpdateReceiveQuantityCommand(lists);
        this.context.invoke((AbstractCommand)command);
        insteads.stream().forEach(o -> OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity())));
    }
}

