/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurOrderItemBom;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.collection.batchRule.BatchRuleUtils;
import com.els.liby.collection.feed.entity.OemFeedOrderItemExt;
import com.els.liby.collection.oem.command.batch.CreateBatchCommand;
import com.els.liby.collection.oem.command.batch.GetBomByOrderItemIdCommand;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.oem.utils.OembatchUtils;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.util.GetVoucherNoUtil;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class CreateOemOrderInsteadCommand
extends AbstractCommand<OemOrderInstead> {
    private OemOrderInstead oemOrderInstead;

    public CreateOemOrderInsteadCommand(OemOrderInstead oemOrderInstead) {
        this.oemOrderInstead = oemOrderInstead;
    }

    public OemOrderInstead execute(ICommandInvoker context) {
        PurchaseOrderItem purchaseOrderItem = OemOrderItemUtils.vaidOrderstatus(this.oemOrderInstead.getOrderNo(), this.oemOrderInstead.getOrderItemId(), this.oemOrderInstead.getReceivedQuantity());
        this.init(this.oemOrderInstead, purchaseOrderItem);
        this.vaidRequire(this.oemOrderInstead);
        this.initSapBatch(this.oemOrderInstead);
        OemContextUtils.getOemOrderInsteadService().addObj(this.oemOrderInstead);
        this.saveBombacth(this.oemOrderInstead);
        this.addOemOrderItemExt(this.oemOrderInstead);
        return this.oemOrderInstead;
    }

    private void initSapBatch(OemOrderInstead o) {
        String sapBatchNum = BatchRuleUtils.getOemBatch(o.getOrderType(), o.getPurchaseGroup(), o.getFactory(), o.getInsteadReceiptDate(), o.getDateBeforeRework());
        o.setBatchNumber(sapBatchNum);
    }

    private void vaidRequire(OemOrderInstead oemOrderInstead) {
        Assert.isNotBlank((String)oemOrderInstead.getReceivedQuantity().toString(), (String)"\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemOrderInstead.getOrderNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemOrderInstead.getOrderItemNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemOrderInstead.getOrderItemId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
        if ("C310".equals(oemOrderInstead.getOrderType()) || "Z310".equals(oemOrderInstead.getOrderType())) {
            Assert.isNotBlank((String)oemOrderInstead.getPurchaseGroup(), (String)"\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            if ("011".equals(oemOrderInstead.getPurchaseGroup()) || "013".equals(oemOrderInstead.getPurchaseGroup())) {
                Assert.isNotNull((Object)oemOrderInstead.getDateBeforeRework(), (String)"\u8fd4\u5de5\u524d\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void addOemOrderItemExt(OemOrderInstead o) {
        OemFeedOrderItemExt oemOrderItemExt = OemContextUtils.getOemFeedOrderItemExtService().queryByItemId(o.getOrderItemId());
        if (oemOrderItemExt != null) {
            OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(o.getOrderItemId(), o.getReceivedQuantity());
        } else {
            OemFeedOrderItemExt ext = new OemFeedOrderItemExt();
            ext.setOrderId(o.getOrderId());
            ext.setOrderNo(o.getOrderNo());
            ext.setOrderItemId(o.getOrderItemId());
            ext.setOrderItemNo(o.getOrderItemNo());
            ext.setUnsubmittedQuantity(o.getReceivedQuantity());
            ext.setSubmittedQuantity(BigDecimal.ZERO);
            ext.setWriteOffQuantity(BigDecimal.ZERO);
            ext.setReturnBackQuantity(BigDecimal.ZERO);
            ext.setReceivedQuantity(BigDecimal.ZERO);
            OemContextUtils.getOemFeedOrderItemExtService().addObj(ext);
        }
    }

    private void init(OemOrderInstead o, PurchaseOrderItem purchaseOrderItem) {
        o.setSupCompanySapId(purchaseOrderItem.getSupCompanyId());
        o.setSupCompanySapCode(purchaseOrderItem.getSupCompanySapCode());
        o.setSupCompanyName(purchaseOrderItem.getSupCompanyName());
        o.setQuantity(purchaseOrderItem.getQuantity());
        o.setOrderUnit(purchaseOrderItem.getOrderUnit());
        o.setWarehouseLocation(purchaseOrderItem.getWarehouseLocation());
        o.setDeliveredDate(purchaseOrderItem.getDeliveredDate());
        o.setId(UUIDGenerator.generateUUID());
        o.setReceiptVoucherIitemNo("1");
        o.setSendStatus(OemSendStatusEnum.UNSUBMITTED.getValue());
        o.setConfirmStatus(OemConfirmStatusEnum.UNCOLLECTED.getValue());
        o.setWriteOffFlag(OemWriteOffEnum.UN_WRITE_OFF.getValue());
        o.setCreateUserId(this.getSupUser().getId());
        o.setCreateUserName(this.getSupUser().getNickName());
        o.setCreateTime(new Date());
        o.setPostingTime(o.getPostingTime() == null ? new Date() : o.getPostingTime());
        o.setInsteadReceiptVoucher(GetVoucherNoUtil.getOemVoucher(o.getFactory()));
    }

    private void saveBombacth(OemOrderInstead o) {
        List<OemOrderInsteadBatch> batchList = this.oemOrderInstead.getBatchList();
        CreateBatchCommand command = null;
        if (CollectionUtils.isNotEmpty(batchList)) {
            batchList.stream().map(batch -> {
                batch.setOemInsteadId(o.getId());
                batch.setInsteadVoucherNo(o.getInsteadReceiptVoucher());
                batch.setInsteadVoucherItemNo(o.getReceiptVoucherIitemNo());
                batch.setFactory(o.getFactory());
                batch.setWarehouseLocation(o.getWarehouseLocation());
                return batch;
            }).filter(batch -> !batch.getMaterialCode().startsWith("8")).forEach(batch -> batch.setBatchQuantity(batch.getRequiredQuantity()));
            command = new CreateBatchCommand(batchList);
        } else {
            GetBomByOrderItemIdCommand bomCommand = new GetBomByOrderItemIdCommand(o);
            List bomList = (List)this.context.invoke((AbstractCommand)bomCommand);
            if (CollectionUtils.isNotEmpty((Collection)bomList)) {
                batchList = this.buildBatch(bomList, o);
                command = new CreateBatchCommand(batchList, false);
            }
        }
        if (CollectionUtils.isEmpty(batchList)) {
            return;
        }
        command.copyProperties(this);
        this.context.invoke((AbstractCommand)command);
    }

    private List<OemOrderInsteadBatch> buildBatch(List<PurOrderItemBom> bomList, OemOrderInstead o) {
        List<OemOrderInsteadBatch> batchList = bomList.stream().map(bom -> {
            OemOrderInsteadBatch batch = new OemOrderInsteadBatch();
            BeanUtils.copyProperties((Object)bom, (Object)batch);
            batch.setId(UUIDGenerator.generateUUID());
            batch.setOemInsteadId(o.getId());
            batch.setInsteadVoucherNo(o.getInsteadReceiptVoucher());
            batch.setInsteadVoucherItemNo(o.getReceiptVoucherIitemNo());
            batch.setFactory(o.getFactory());
            batch.setWarehouseLocation(o.getWarehouseLocation());
            BigDecimal quiredQuantity = OembatchUtils.ComputeRequiredQuantity(bom.getRequiredQuantity(), o.getQuantity(), o.getReceivedQuantity());
            batch.setRequiredQuantity(quiredQuantity);
            batch.setBatchQuantity(quiredQuantity);
            return batch;
        }).collect(Collectors.toList());
        return batchList;
    }
}

