/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.liby.collection.batchRule.BatchRuleUtils;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ModifyOemOrderInsteadCommand
extends AbstractCommand {
    private OemOrderInstead oemOrderInstead;

    public ModifyOemOrderInsteadCommand(OemOrderInstead oemOrderInstead) {
        this.oemOrderInstead = oemOrderInstead;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemOrderInstead);
        this.vaidRequire(this.oemOrderInstead);
        this.vaidOrderStatus(this.oemOrderInstead);
        this.init(this.oemOrderInstead);
        OemContextUtils.getOemOrderInsteadService().modifyObj(this.oemOrderInstead);
        OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(this.oemOrderInstead.getOrderItemId(), this.oemOrderInstead.getReceivedQuantity());
        return null;
    }

    private void vaidOrderStatus(OemOrderInstead o) {
        OemOrderInstead instead = (OemOrderInstead)OemContextUtils.getOemOrderInsteadService().queryObjById(o.getId());
        if (OemSendStatusEnum.UNSUBMITTED.getValue() == instead.getSendStatus().intValue() || OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue() == instead.getSendStatus().intValue()) {
            OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(instead.getReceivedQuantity()));
        } else if (OemConfirmStatusEnum.RETURN_BACK.getValue() == instead.getConfirmStatus().intValue()) {
            OemContextUtils.getOemFeedOrderItemExtService().addReturnQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(instead.getReceivedQuantity()));
        } else if (OemConfirmStatusEnum.COLLECTED_FAIL.getValue() == instead.getConfirmStatus().intValue()) {
            OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(instead.getReceivedQuantity()));
        }
        OemOrderItemUtils.vaidOrderstatus(o.getOrderNo(), o.getOrderItemId(), o.getReceivedQuantity());
        this.vaidReceivedQuantity(o.getReceivedQuantity(), instead);
    }

    private void vaidReceivedQuantity(BigDecimal NewreceivedQuantity, OemOrderInstead instead) {
        if (NewreceivedQuantity.compareTo(instead.getReceivedQuantity()) != 0) {
            List<OemOrderInsteadBatch> bomList = OemContextUtils.getOemOrderInsteadBatchService().queryAllObjByInsteadId(instead.getId());
            if (CollectionUtils.isEmpty(bomList)) {
                return;
            }
            bomList.stream().forEach(bom -> {
                BigDecimal quantity = bom.getRequiredQuantity().divide(instead.getReceivedQuantity(), 3, 5).multiply(NewreceivedQuantity);
                bom.setRequiredQuantity(quantity);
                bom.setBatchNumber("");
                bom.setBatchQuantity(quantity);
                OemContextUtils.getOemOrderInsteadBatchService().modifyObj((Serializable)bom);
            });
        }
    }

    private void vaidRequire(OemOrderInstead oemOrderInstead) {
        Assert.isNotBlank((String)oemOrderInstead.getReceivedQuantity().toString(), (String)"\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemOrderInstead.getOrderNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemOrderInstead.getOrderItemNo(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)oemOrderInstead.getOrderItemId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
        if ("C310".equals(oemOrderInstead.getOrderType()) || "Z310".equals(oemOrderInstead.getOrderType())) {
            Assert.isNotBlank((String)oemOrderInstead.getPurchaseGroup(), (String)"\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            if ("011".equals(oemOrderInstead.getPurchaseGroup()) || "013".equals(oemOrderInstead.getPurchaseGroup())) {
                Assert.isNotNull((Object)oemOrderInstead.getDateBeforeRework(), (String)"\u8fd4\u5de5\u524d\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void init(OemOrderInstead o) {
        o.setSendStatus(OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue());
        String sapBatchNum = BatchRuleUtils.getOemBatch(o.getOrderType(), o.getPurchaseGroup(), o.getFactory(), o.getInsteadReceiptDate(), o.getDateBeforeRework());
        o.setBatchNumber(sapBatchNum);
    }

    private void vaidStatus(OemOrderInstead o) {
        if ("Y".equals(o.getWriteOffFlag())) {
            throw new CommonException("\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u51b2\u9500");
        }
        if (OemConfirmStatusEnum.RETURN_BACK.getValue() != o.getConfirmStatus().intValue() && OemConfirmStatusEnum.COLLECTED_FAIL.getValue() != o.getConfirmStatus().intValue() && Constant.YES_INT.equals(o.getSendStatus())) {
            throw new CommonException("\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u63d0\u4ea4");
        }
    }
}

