/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.liby.collection.command.ModifyOemOrderItemCanDeliveryCmd;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadExample;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ReturnCommand
extends AbstractCommand {
    private List<OemOrderInstead> oemOrderInsteads;

    public ReturnCommand(List<OemOrderInstead> oemOrderInsteads) {
        this.oemOrderInsteads = oemOrderInsteads;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemOrderInsteads);
        this.saveReturnBackQuantity(this.oemOrderInsteads);
        List ids = this.oemOrderInsteads.stream().map(o -> o.getId()).collect(Collectors.toList());
        OemOrderInstead instead = new OemOrderInstead();
        instead.setConfirmStatus(OemConfirmStatusEnum.RETURN_BACK.getValue());
        instead.setReturnDate(new Date());
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.createCriteria().andIdIn(ids);
        OemContextUtils.getOemOrderInsteadService().modifybyExample(instead, example);
        List<String> itemIds = this.oemOrderInsteads.stream().map(o -> o.getOrderItemId()).collect(Collectors.toList());
        ModifyOemOrderItemCanDeliveryCmd cmd = new ModifyOemOrderItemCanDeliveryCmd(itemIds);
        context.invoke((AbstractCommand)cmd);
        return null;
    }

    private void vaidStatus(List<OemOrderInstead> oemOrderInsteads) {
        oemOrderInsteads.stream().forEach(o -> {
            if (OemConfirmStatusEnum.RETURN_BACK.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u62d2\u6536");
            }
            if (OemConfirmStatusEnum.COLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u786e\u8ba4");
            }
            if (OemConfirmStatusEnum.COLLECTED_FAIL.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u786e\u8ba4\u5931\u8d25");
            }
            if (Constant.NO_INT.equals(o.getSendStatus())) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u672a\u63d0\u4ea4");
            }
            if ("Y".equals(o.getWriteOffFlag())) {
                throw new CommonException("\u62d2\u6536\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u51b2\u9500");
            }
        });
    }

    private void saveReturnBackQuantity(List<OemOrderInstead> oemOrderInsteads) {
        oemOrderInsteads.stream().forEach(o -> {
            OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            OemContextUtils.getOemFeedOrderItemExtService().addReturnQuantity(o.getOrderItemId(), o.getReceivedQuantity());
        });
    }
}

