/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.liby.collection.command.ModifyOemOrderItemCanDeliveryCmd;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.oem.entity.OemOrderInsteadExample;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class SendCommand
extends AbstractCommand {
    private static String MSG = "\u91c7\u8d2d\u8ba2\u5355=%s|\u7269\u6599\u7f16\u53f7=%s|\u6536\u8d27\u6570\u91cf=%s|\u6536\u8d27\u65f6\u95f4=%s";
    private List<OemOrderInstead> oemOrderInsteads;

    public SendCommand(List<OemOrderInstead> oemOrderInsteads) {
        this.oemOrderInsteads = oemOrderInsteads;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemOrderInsteads);
        this.vaidBatch(this.oemOrderInsteads);
        this.saveSubmitQuantity(this.oemOrderInsteads);
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        OemOrderInstead instead = new OemOrderInstead();
        instead.setSendStatus(OemSendStatusEnum.SUBMITTED.getValue());
        instead.setConfirmStatus(OemConfirmStatusEnum.UNCOLLECTED.getValue());
        instead.setConfirmFailReason(" ");
        instead.setSendDate(new Date());
        List ids = this.oemOrderInsteads.stream().map(o -> o.getId()).collect(Collectors.toList());
        example.createCriteria().andIdIn(ids);
        OemContextUtils.getOemOrderInsteadService().modifybyExample(instead, example);
        List<String> itemIds = this.oemOrderInsteads.stream().map(o -> o.getOrderItemId()).collect(Collectors.toList());
        ModifyOemOrderItemCanDeliveryCmd cmd = new ModifyOemOrderItemCanDeliveryCmd(itemIds);
        context.invoke((AbstractCommand)cmd);
        return null;
    }

    private void vaidBatch(List<OemOrderInstead> oemOrderInsteads) {
        for (OemOrderInstead o : oemOrderInsteads) {
            String msg = o.getInsteadReceiptVoucher() == null ? String.format(MSG, o.getOrderNo(), o.getMaterialCode(), o.getReceivedQuantity(), DateFormatUtils.format((Date)o.getInsteadReceiptDate(), (String)"yyyy-MM-dd HH:mm:ss")) : "\u4ee3\u6536\u51ed\u8bc1\uff1a" + o.getInsteadReceiptVoucher();
            List<OemOrderInsteadBatch> batches = OemContextUtils.getOemOrderInsteadBatchService().queryBomProductByInsteadId(o.getId());
            List withoutBatchNumList = batches.stream().filter(b -> StringUtils.isBlank((String)b.getBatchNumber())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(withoutBatchNumList)) {
                throw new CommonException(msg + "\uff0cBOM\u6210\u54c1\u3001\u534a\u6210\u54c1\u672a\u6307\u5b9a\u6d88\u8017\u6279\u6b21");
            }
            Map<String, List<OemOrderInsteadBatch>> group = batches.stream().collect(Collectors.groupingBy(OemOrderInsteadBatch::getMaterialCode));
            for (String key : group.keySet()) {
                List<OemOrderInsteadBatch> lists = group.get(key);
                BigDecimal total = lists.stream().map(b -> b.getBatchQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
                if (total.compareTo(lists.get(0).getRequiredQuantity()) == 0) continue;
                throw new CommonException(msg + "\uff0cBOM\u7269\u6599\u7f16\u53f7\uff1a" + lists.get(0).getMaterialCode() + "\u6d88\u8017\u6570\u91cf\u603b\u548c\u4e0d\u7b49\u4e8e\u9700\u6c42\u6570\u91cf");
            }
        }
    }

    private void vaidStatus(List<OemOrderInstead> oemOrderInsteads) {
        oemOrderInsteads.stream().forEach(o -> {
            if (OemSendStatusEnum.SUBMITTED.getValue() == o.getSendStatus().intValue()) {
                throw new CommonException("\u63d0\u4ea4\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u53d1\u9001");
            }
            if (OemConfirmStatusEnum.COLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u63d0\u4ea4\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u786e\u8ba4");
            }
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(o.getWriteOffFlag())) {
                throw new CommonException("\u63d0\u4ea4\u5931\u8d25\uff1b" + o.getInsteadReceiptVoucher() + "\u51ed\u8bc1" + o.getReceiptVoucherIitemNo() + "\u884c\u5df2\u51b2\u9500");
            }
        });
    }

    private void saveSubmitQuantity(List<OemOrderInstead> oemOrderInsteads) {
        oemOrderInsteads.stream().forEach(o -> {
            if (OemSendStatusEnum.UNSUBMITTED_MODIFY.getValue() == o.getSendStatus().intValue() || OemSendStatusEnum.UNSUBMITTED.getValue() == o.getSendStatus().intValue()) {
                OemContextUtils.getOemFeedOrderItemExtService().addUnsubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            } else if (OemConfirmStatusEnum.RETURN_BACK.getValue() == o.getConfirmStatus().intValue()) {
                OemContextUtils.getOemFeedOrderItemExtService().addReturnQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            } else if (OemConfirmStatusEnum.COLLECTED_FAIL.getValue() == o.getConfirmStatus().intValue()) {
                OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(o.getOrderItemId(), BigDecimal.ZERO.subtract(o.getReceivedQuantity()));
            }
            OemContextUtils.getOemFeedOrderItemExtService().addSubmittedQuantity(o.getOrderItemId(), o.getReceivedQuantity());
        });
    }
}

