/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command.batch;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatchExample;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.util.OemContextUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CreateBatchCommand
extends AbstractCommand {
    private List<OemOrderInsteadBatch> batchs;
    private Boolean collectStatus;

    public CreateBatchCommand(List<OemOrderInsteadBatch> batchs) {
        this.batchs = batchs;
        this.collectStatus = true;
    }

    public CreateBatchCommand(List<OemOrderInsteadBatch> batchs, Boolean collectStatus) {
        this.batchs = batchs;
        this.collectStatus = collectStatus;
    }

    public Object execute(ICommandInvoker context) {
        this.vaid(this.batchs);
        this.init(this.batchs);
        this.save(this.batchs);
        return null;
    }

    private void init(List<OemOrderInsteadBatch> batch) {
        batch.stream().forEach(b -> {
            b.setCreateTime(new Date());
            b.setCreateUserId(this.getSupUser().getId());
            b.setCreateUserName(this.getSupUser().getNickName());
            b.setId(UUIDGenerator.generateUUID());
        });
        this.initStorageocation(batch);
    }

    private void initStorageocation(List<OemOrderInsteadBatch> batchs) {
        OemOrderInstead instead = (OemOrderInstead)OemContextUtils.getOemOrderInsteadService().queryObjById(batchs.get(0).getOemInsteadId());
        for (OemOrderInsteadBatch batch : batchs) {
            if (!batch.getMaterialCode().startsWith("8")) {
                if ("8702_6160".equals(batch.getFactory() + "_" + batch.getWarehouseLocation())) {
                    batch.setStorageLocation("1010");
                    continue;
                }
                batch.setStorageLocation("1000");
                continue;
            }
            OrganizationExample example = new OrganizationExample();
            OrganizationExample.Criteria criteria = example.createCriteria();
            criteria.andFactorycodeEqualTo(batch.getFactory());
            if (("C310".equals(instead.getOrderType()) || "Z310".equals(instead.getOrderType())) && !"011".equals(instead.getPurchaseGroup())) {
                criteria.andCodeLike("%3");
                criteria.andDescriptionLike("%\u5f85\u5904\u7406%");
            } else {
                criteria.andCodeLike("%4");
                criteria.andDescriptionLike("%\u534a\u6210\u54c1%");
            }
            List list = OemContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
            batch.setStorageLocation(((Organization)list.get(0)).getCode());
        }
    }

    private void vaid(List<OemOrderInsteadBatch> batch) {
        List mustLists = batch.stream().filter(b -> b.getMaterialCode().startsWith("8")).collect(Collectors.toList());
        mustLists.stream().forEach(b -> {
            Assert.isNotBlank((String)b.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            Assert.isNotBlank((String)b.getMaterialDesc(), (String)"\u7269\u6599\u63cf\u8ff0\u4e3a\u7a7a");
            if (this.collectStatus.booleanValue()) {
                Assert.isNotBlank((String)b.getBatchNumber(), (String)"\u6d88\u8017\u6279\u6b21\u4e3a\u7a7a");
            }
            if (b.getBatchQuantity() == null || b.getBatchQuantity().equals(BigDecimal.ZERO)) {
                throw new CommonException("\u6d88\u8017\u6570\u91cf\u4e3a\u7a7a");
            }
        });
        Map<String, List<OemOrderInsteadBatch>> group = mustLists.stream().collect(Collectors.groupingBy(OemOrderInsteadBatch::getMaterialCode));
        for (String key : group.keySet()) {
            List<OemOrderInsteadBatch> lists = group.get(key);
            BigDecimal total = lists.stream().map(b -> b.getBatchQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
            if (total.compareTo(lists.get(0).getRequiredQuantity()) == 0) continue;
            throw new CommonException("\u7269\u6599\u7f16\u53f7\uff1a" + lists.get(0).getMaterialCode() + "\u6d88\u8017\u6570\u91cf\u603b\u548c\u4e0d\u7b49\u4e8e\u9700\u6c42\u6570\u91cf");
        }
    }

    private void save(List<OemOrderInsteadBatch> batchs) {
        OemOrderInsteadBatchExample example = new OemOrderInsteadBatchExample();
        example.createCriteria().andOemInsteadIdEqualTo(batchs.get(0).getOemInsteadId());
        OemContextUtils.getOemOrderInsteadBatchService().deleteByExample((IExample)example);
        OemContextUtils.getOemOrderInsteadBatchService().addAll(batchs);
    }
}

