/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command.batch;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurOrderItemBom;
import com.els.base.purchase.entity.PurOrderItemBomExample;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.utils.OembatchUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class GetBomByOrderItemIdCommand
extends AbstractCommand<List<PurOrderItemBom>> {
    private OemOrderInstead oemOrderInstead;

    public GetBomByOrderItemIdCommand(OemOrderInstead oemOrderInstead) {
        this.oemOrderInstead = oemOrderInstead;
    }

    public List<PurOrderItemBom> execute(ICommandInvoker context) {
        Assert.isNotNull((Object)this.oemOrderInstead, (String)"\u4ee3\u6536\u51ed\u8bc1\u8bb0\u5f55\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.oemOrderInstead.getOrderItemId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cID\u4e3a\u7a7a");
        PurOrderItemBomExample bomExample = new PurOrderItemBomExample();
        bomExample.createCriteria().andOrderItemIdEqualTo(this.oemOrderInstead.getOrderItemId());
        List bomList = ContextUtils.getPurOrderItemBomService().queryAllObjByExample((IExample)bomExample);
        if (CollectionUtils.isEmpty((Collection)bomList)) {
            return null;
        }
        BigDecimal quantity = this.oemOrderInstead.getQuantity();
        BigDecimal receivedQuantity = this.oemOrderInstead.getReceivedQuantity();
        bomList.stream().forEach(bom -> {
            BigDecimal requiredQuantity = OembatchUtils.ComputeRequiredQuantity(bom.getRequiredQuantity(), quantity, receivedQuantity);
            bom.setRequiredQuantity(requiredQuantity);
        });
        return bomList;
    }
}

