/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command.batch;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.liby.collection.oem.sap.materialBatch.ZSRMRFCWLPC2;
import com.els.liby.collection.oem.sap.materialBatch.ZSRMRFCWLPCResponse;
import com.els.liby.quota.service.SoapServiceRequestText;
import com.els.liby.util.OemSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMaterialBatchCommand
extends AbstractCommand<List<ZSRMRFCWLPC2>> {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialBatchCommand.class);
    private static String PAT = "000000000000000000";
    private static String username = OemSapConfUtils.getServiceUsername();
    private static String password = OemSapConfUtils.getServicePassword();
    private static String serviceNameSpace = OemSapConfUtils.getNameSpace();
    private static String serviceUrl = OemSapConfUtils.getMaterialBatchUrl();
    private static String serviceMethod = OemSapConfUtils.getMaterialBatchServiceMethod();
    private String factory;
    private String materialCode;
    private String warehouseLocation;

    public GetMaterialBatchCommand(String factory, String materialCode, String warehouseLocation) {
        this.factory = factory;
        this.materialCode = materialCode;
        this.warehouseLocation = warehouseLocation;
    }

    public List<ZSRMRFCWLPC2> execute(ICommandInvoker context) {
        ZSRMRFCWLPCResponse data = this.getDataFromSap();
        if (data.getETDATA() == null) {
            return null;
        }
        List<ZSRMRFCWLPC2> lists = data.getETDATA().getItem();
        if (CollectionUtils.isEmpty(lists)) {
            return null;
        }
        lists.parallelStream().forEach(z -> z.setMATNR(z.getMATNR().replaceFirst("^0*", "")));
        return data.getETDATA().getItem();
    }

    private ZSRMRFCWLPCResponse getDataFromSap() {
        log.debug("\u3010\u7269\u6599\u6279\u6b21\u6570\u91cf\u67e5\u8be2\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.buildXmlParams();
        request.setXmlParams(xmlParams);
        log.debug(String.format("EVENT=\u7269\u6599\u6279\u6b21\u6570\u91cf\u67e5\u8be2|REQUEST_URL=%s|REQUEST_PARAMS=%s", serviceUrl, xmlParams));
        HttpCallbackResultVO vo = request.execute(ZSRMRFCWLPCResponse.class);
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error(String.format("EVENT=\u7269\u6599\u6279\u6b21\u6570\u91cf\u67e5\u8be2|CONTENT=%s", vo.getError()));
            throw new CommonException("\u7269\u6599\u6279\u6b21\u6570\u91cf\u67e5\u8be2\u5f02\u5e38");
        }
        ZSRMRFCWLPCResponse respone = (ZSRMRFCWLPCResponse)vo.getResult();
        if (respone == null) {
            throw new CommonException("\u4f9b\u5e94\u5546\u53d1\u8d27\u5355,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        log.error(String.format("EVENT=\u7269\u6599\u6279\u6b21\u6570\u91cf\u67e5\u8be2|\u5171\u8ba1\u6570\u91cfNUM=%s", respone.getETDATA().getItem().size()));
        return respone;
    }

    private String buildXmlParams() {
        StringBuilder sb = new StringBuilder();
        sb.append("<ET_DATA></ET_DATA>");
        if (StringUtils.isNotBlank((String)this.warehouseLocation)) {
            sb.append(" <IT_LGORT>");
            sb.append(" <item>");
            sb.append("<SIGN>I</SIGN>");
            sb.append("<OPTION>EQ</OPTION>");
            sb.append("<STLOC_LOW>" + this.warehouseLocation + "</STLOC_LOW>");
            sb.append(" </item>");
            sb.append("</IT_LGORT>");
        }
        if (StringUtils.isNotBlank((String)this.materialCode)) {
            sb.append(" <IT_MATNR>");
            sb.append(" <item>");
            sb.append("<SIGN>I</SIGN>");
            sb.append("<OPTION>EQ</OPTION>");
            sb.append("<LOW>" + PAT.substring(0, PAT.length() - this.materialCode.length()) + this.materialCode + "</LOW>");
            sb.append(" </item>");
            sb.append("   </IT_MATNR>");
        }
        if (StringUtils.isNotBlank((String)this.factory)) {
            String[] factorys;
            sb.append(" <IT_WERKS>");
            for (String factory : factorys = this.factory.split(",")) {
                sb.append(" <item>");
                sb.append("<SIGN>I</SIGN>");
                sb.append("<OPTION>EQ</OPTION>");
                sb.append("<LOW>" + factory + "</LOW>");
                sb.append(" </item>");
            }
            sb.append(" </IT_WERKS>");
        }
        return sb.toString();
    }
}

