/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.command.batch;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.purchase.entity.PurOrderItemBom;
import com.els.base.purchase.entity.PurOrderItemBomExample;
import com.els.liby.collection.oem.utils.OembatchUtils;
import java.math.BigDecimal;
import java.util.List;

public class ViewBomCommand
extends AbstractCommand<List<PurOrderItemBom>> {
    private BigDecimal quantity;
    private BigDecimal receivedQuantity;
    private String orderItemId;

    public ViewBomCommand(BigDecimal quantity, BigDecimal receivedQuantity, String orderItemId) {
        this.quantity = quantity;
        this.receivedQuantity = receivedQuantity;
        this.orderItemId = orderItemId;
    }

    public List<PurOrderItemBom> execute(ICommandInvoker context) {
        PurOrderItemBomExample bomExample = new PurOrderItemBomExample();
        bomExample.createCriteria().andOrderItemIdEqualTo(this.orderItemId);
        List bomList = ContextUtils.getPurOrderItemBomService().queryAllObjByExample((IExample)bomExample);
        bomList.stream().forEach(bom -> {
            BigDecimal requiredQuantity = OembatchUtils.ComputeRequiredQuantity(bom.getRequiredQuantity(), this.quantity, this.receivedQuantity);
            bom.setRequiredQuantity(requiredQuantity);
        });
        return bomList;
    }
}

