/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.PurOrderItemBom;
import com.els.liby.collection.oem.command.batch.CreateBatchCommand;
import com.els.liby.collection.oem.command.batch.GetBomByOrderItemIdCommand;
import com.els.liby.collection.oem.command.batch.ModifyBatchCommand;
import com.els.liby.collection.oem.command.batch.ViewBomCommand;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatchExample;
import com.els.liby.collection.oem.service.OemOrderInsteadBatchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="OEM\u91c7\u8d2d\u8ba2\u5355-bom\u7684\u6d88\u8017\u6279\u6b21\u8868")
@Controller
@RequestMapping(value={"oemOrderInsteadBatch"})
public class OemOrderInsteadBatchController {
    @Resource
    protected OemOrderInsteadBatchService oemOrderInsteadBatchService;
    @Resource
    private OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaOEM\u91c7\u8d2d\u8ba2\u5355-bom\u7684\u6d88\u8017\u6279\u6b21\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<OemOrderInsteadBatch> oemOrderInsteadBatchs) {
        CreateBatchCommand command = new CreateBatchCommand(oemOrderInsteadBatchs);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91OEM\u91c7\u8d2d\u8ba2\u5355-bom\u7684\u6d88\u8017\u6279\u6b21\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<OemOrderInsteadBatch> oemOrderInsteadBatchs) {
        ModifyBatchCommand command = new ModifyBatchCommand(oemOrderInsteadBatchs);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664OEM\u91c7\u8d2d\u8ba2\u5355-bom\u7684\u6d88\u8017\u6279\u6b21\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        OemOrderInsteadBatchExample example = new OemOrderInsteadBatchExample();
        example.createCriteria().andIdIn((List)ids);
        this.oemOrderInsteadBatchService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2OEM\u91c7\u8d2d\u8ba2\u5355-bom\u7684\u6d88\u8017\u6279\u6b21\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemOrderInsteadBatch", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemOrderInsteadBatch>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemOrderInsteadBatchExample example = new OemOrderInsteadBatchExample();
        example.setPageView((PageView<OemOrderInsteadBatch>)new PageView(pageNo, pageSize));
        OemOrderInsteadBatchExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemOrderInsteadBatchService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u6839\u636e\u4ee3\u6536\u51ed\u8bc1\u8bb0\u5f55\u67e5\u8be2\u6709\u6ca1\u6709\u6307\u5b9a\u6d88\u8017\u6279\u6b21", httpMethod="POST")
    @RequestMapping(value={"service/findBatchByInsteadId"})
    @ResponseBody
    public ResponseResult<List<OemOrderInsteadBatch>> findBatchByInsteadId(@RequestBody OemOrderInstead oemOrderInstead) {
        List<OemOrderInsteadBatch> batches = this.oemOrderInsteadBatchService.queryAllObjByInsteadId(oemOrderInstead.getId());
        Assert.isNotEmpty(batches, (String)"\u5f53\u524d\u4ee3\u6536\u51ed\u8bc1\u6ca1\u6709\u6307\u5b9a\u6d88\u8017\u6279\u6b21\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6279\u6b21");
        return ResponseResult.success(batches);
    }

    @ApiOperation(value="\u6839\u636e\u91c7\u8d2d\u8ba2\u5355\u884cID\u67e5\u8be2BOM", httpMethod="POST")
    @RequestMapping(value={"service/findBomByOemInstead"})
    @ResponseBody
    public ResponseResult<List<PurOrderItemBom>> findBomByOemInstead(@RequestBody OemOrderInstead oemOrderInstead) {
        GetBomByOrderItemIdCommand command = new GetBomByOrderItemIdCommand(oemOrderInstead);
        List bomList = (List)this.invoker.invoke((AbstractCommand)command);
        Assert.isNotEmpty((Collection)bomList, (String)"\u5f53\u524d\u4ee3\u6536\u51ed\u8bc1\u4e0d\u5b58\u5728BOM");
        return ResponseResult.success((Object)bomList);
    }

    @ApiOperation(value="\u6536\u8d27\u9884\u89c8BOM", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="quantity", required=true, value="\u586b\u5165\u7684\u6536\u8d27\u6570\u91cf", dataType="BigDecimal"), @ApiImplicitParam(name="receivedQuantity", required=true, value="\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf", dataType="BigDecimal"), @ApiImplicitParam(name="orderItemId", required=true, value="\u91c7\u8d2d\u8ba2\u5355\u884cID", dataType="String")})
    @RequestMapping(value={"service/ViewBom"})
    @ResponseBody
    public ResponseResult<List<PurOrderItemBom>> ViewBom(@RequestParam BigDecimal quantity, @RequestParam BigDecimal receivedQuantity, @RequestParam String orderItemId) {
        Assert.isNotNull((Object)receivedQuantity, (String)"\u4ee3\u6536\u6570\u91cf\u4e3a\u7a7a");
        Assert.isNotBlank((String)orderItemId, (String)"\u91c7\u8d2d\u8ba2\u5355\u884cID\u4e3a\u7a7a");
        Assert.isNotNull((Object)quantity, (String)"\u8ba2\u5355\u6570\u91cf\u4e3a\u7a7a");
        ViewBomCommand command = new ViewBomCommand(quantity, receivedQuantity, orderItemId);
        List bomList = (List)this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success((Object)bomList);
    }
}

