/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.liby.collection.command.ViewOemInsteadOrderCommand;
import com.els.liby.collection.command.ViewOemOrderCommand;
import com.els.liby.collection.oem.command.BatchCreateOemInsteadCmd;
import com.els.liby.collection.oem.command.CollectedCommand;
import com.els.liby.collection.oem.command.CreateAndSendOemInsteadCmd;
import com.els.liby.collection.oem.command.ModifyOemOrderInsteadCommand;
import com.els.liby.collection.oem.command.ModifyPostingTimeCommand;
import com.els.liby.collection.oem.command.ReturnCommand;
import com.els.liby.collection.oem.command.SendCommand;
import com.els.liby.collection.oem.command.WriteOffCommand;
import com.els.liby.collection.oem.command.batch.GetMaterialBatchCommand;
import com.els.liby.collection.oem.entity.OemOrderInstead;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.oem.entity.OemOrderInsteadExample;
import com.els.liby.collection.oem.sap.materialBatch.ZSRMRFCWLPC2;
import com.els.liby.collection.oem.service.OemOrderInsteadBatchService;
import com.els.liby.collection.oem.service.OemOrderInsteadService;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.collection.utils.OemOrderItems;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="Oem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27")
@Controller
@RequestMapping(value={"oemOrderInstead"})
public class OemOrderInsteadController {
    @Resource
    protected OemOrderInsteadService oemOrderInsteadService;
    @Resource
    protected OemOrderInsteadBatchService oemOrderInsteadBatchService;
    @Resource
    private OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaOem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<OemOrderInstead> oemOrderInsteads) {
        BatchCreateOemInsteadCmd command = new BatchCreateOemInsteadCmd(oemOrderInsteads);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91Oem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody OemOrderInstead oemOrderInstead) {
        Assert.isNotBlank((String)oemOrderInstead.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyOemOrderInsteadCommand command = new ModifyOemOrderInsteadCommand(oemOrderInstead);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664Oem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.createCriteria().andIdIn((List)ids);
        this.oemOrderInsteadService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5f85\u5904\u7406Oem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemOrderInstead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findUntreatedByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemOrderInstead>> purFindUncollectedByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.setOrderByClause(" INSTEAD_RECEIPT_VOUCHER DESC");
        example.setPageView((PageView<OemOrderInstead>)new PageView(pageNo, pageSize));
        OemOrderInsteadExample.Criteria criteria = example.createCriteria();
        criteria.andConfirmStatusIn((List)Arrays.asList(OemConfirmStatusEnum.UNCOLLECTED.getValue(), OemConfirmStatusEnum.COLLECTED_FAIL.getValue())).andSendStatusEqualTo(OemSendStatusEnum.SUBMITTED.getValue()).andWriteOffFlagEqualTo(OemWriteOffEnum.UN_WRITE_OFF.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(pageData = this.oemOrderInsteadService.queryObjByPage((IExample)example)).getQueryResult())) {
            return ResponseResult.success((Object)pageData);
        }
        this.saveBatch(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7ba1\u7406Oem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemOrderInstead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemOrderInstead>> purFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.setOrderByClause(" INSTEAD_RECEIPT_VOUCHER DESC");
        example.setPageView((PageView<OemOrderInstead>)new PageView(pageNo, pageSize));
        OemOrderInsteadExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(pageData = this.oemOrderInsteadService.queryObjByPage((IExample)example)).getQueryResult())) {
            return ResponseResult.success((Object)pageData);
        }
        this.saveBatch(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5f85\u5904\u7406Oem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemOrderInstead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findUntreatedByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemOrderInstead>> findUnsbumitByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.setOrderByClause(" INSTEAD_RECEIPT_VOUCHER DESC");
        example.setPageView((PageView<OemOrderInstead>)new PageView(pageNo, pageSize));
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        OemOrderInsteadExample.Criteria criteria = example.createCriteria();
        criteria.andSendStatusNotEqualTo(OemSendStatusEnum.SUBMITTED.getValue()).andWriteOffFlagEqualTo(OemWriteOffEnum.UN_WRITE_OFF.getValue()).andFactoryIn((List)oemFactorys);
        example.or().andConfirmStatusIn((List)Arrays.asList(OemConfirmStatusEnum.RETURN_BACK.getValue(), OemConfirmStatusEnum.COLLECTED_FAIL.getValue())).andWriteOffFlagEqualTo(OemWriteOffEnum.UN_WRITE_OFF.getValue()).andFactoryIn((List)oemFactorys);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(pageData = this.oemOrderInsteadService.queryObjByPage((IExample)example)).getQueryResult())) {
            return ResponseResult.success((Object)pageData);
        }
        this.saveBatch(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7ba1\u7406Oem\u91c7\u8d2d\u8ba2\u5355\u4ee3\u6536\u8d27(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemOrderInstead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemOrderInstead>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        OemOrderInsteadExample example = new OemOrderInsteadExample();
        example.setOrderByClause(" INSTEAD_RECEIPT_VOUCHER DESC");
        example.setPageView((PageView<OemOrderInstead>)new PageView(pageNo, pageSize));
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        OemOrderInsteadExample.Criteria criteria = example.createCriteria();
        criteria.andFactoryIn((List)oemFactorys);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(pageData = this.oemOrderInsteadService.queryObjByPage((IExample)example)).getQueryResult())) {
            return ResponseResult.success((Object)pageData);
        }
        this.saveBatch(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee3\u6536\u8d27OEM\u91c7\u8d2d\u8ba2\u5355", httpMethod="POST")
    @RequestMapping(value={"service/findInsteadOEMOrder"})
    @ResponseBody
    public ResponseResult<OemOrderItems> findInsteadOEMOrder(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List<String> types = Arrays.asList("C300", "C301", "C310", "Z300", "Z301", "Z310");
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        ViewOemInsteadOrderCommand cmd = new ViewOemInsteadOrderCommand(types, oemFactorys, wapper);
        return ResponseResult.success((Object)this.invoker.invoke((AbstractCommand)cmd));
    }

    @ApiOperation(value="\u67e5\u8be2OEM\u91c7\u8d2d\u8ba2\u5355", httpMethod="POST")
    @RequestMapping(value={"service/findOEMOrder"})
    @ResponseBody
    public ResponseResult<OemOrderItems> findOEMOrder(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List<String> types = Arrays.asList("C300", "C301", "C310", "Z300", "Z301", "Z310");
        List<String> oemFactorys = OemOrderItemUtils.getOemFactory();
        ViewOemOrderCommand cmd = new ViewOemOrderCommand(types, oemFactorys, wapper);
        return ResponseResult.success((Object)this.invoker.invoke((AbstractCommand)cmd));
    }

    @ApiOperation(value="\u67e5\u8be2\u67e5\u8be2\u7269\u6599\u6279\u6b21", httpMethod="POST")
    @RequestMapping(value={"service/findMaterialBatch"})
    @ResponseBody
    public ResponseResult<List<ZSRMRFCWLPC2>> findMaterialBatch(@RequestParam String factory, String materialCode, String warehouseLocation) {
        Assert.isNotBlank((String)factory, (String)"\u5de5\u5382\u7f16\u7801 \u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
        GetMaterialBatchCommand command = new GetMaterialBatchCommand(factory, materialCode, warehouseLocation);
        return ResponseResult.success((Object)this.invoker.invoke((AbstractCommand)command));
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001")
    @RequestMapping(value={"service/submitByOemOrderInsteads"})
    @ResponseBody
    public ResponseResult<String> submitByOemOrderInsteads(@RequestBody List<OemOrderInstead> oemOrderInsteads) {
        Assert.isNotEmpty(oemOrderInsteads, (String)"\u53d1\u9001\u5931\u8d25,\u53d1\u9001\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        SendCommand command = new SendCommand(oemOrderInsteads);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u786e\u8ba4")
    @RequestMapping(value={"service/collectedByOemOrderInsteads"})
    @ResponseBody
    public ResponseResult<String> collectedByOemOrderInsteads(@RequestBody List<OemOrderInstead> oemOrderInsteads) {
        Assert.isNotEmpty(oemOrderInsteads, (String)"\u786e\u8ba4\u5931\u8d25,\u786e\u8ba4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        CollectedCommand command = new CollectedCommand(oemOrderInsteads);
        List results = (List)this.invoker.invoke((AbstractCommand)command);
        if (oemOrderInsteads.size() > 1) {
            if (results.size() < oemOrderInsteads.size()) {
                return ResponseResult.success((Object)("\u90e8\u5206\u786e\u8ba4\u6210\u529f\uff0c\u6210\u529f\uff1a" + results.size() + "\u6761\uff0c\u5931\u8d25\uff1a" + (oemOrderInsteads.size() - results.size())));
            }
        } else if (results.size() != 1) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail, (Object)"\u786e\u8ba4\u5931\u8d25");
        }
        return ResponseResult.success((Object)"\u786e\u8ba4\u6210\u529f");
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u62d2\u6536")
    @RequestMapping(value={"service/returnBackByOemOrderInsteads"})
    @ResponseBody
    public ResponseResult<String> returnBackByOemOrderInsteads(@RequestBody List<OemOrderInstead> oemOrderInsteads) {
        Assert.isNotEmpty(oemOrderInsteads, (String)"\u62d2\u6536\u5931\u8d25,\u62d2\u6536\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ReturnCommand command = new ReturnCommand(oemOrderInsteads);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u51b2\u9500")
    @RequestMapping(value={"service/WriteOffByOemOrderInsteads"})
    @ResponseBody
    public ResponseResult<String> WriteOffByOemOrderInsteads(@RequestBody List<OemOrderInstead> oemOrderInsteads) {
        Assert.isNotEmpty(oemOrderInsteads, (String)"\u51b2\u9500\u5931\u8d25,\u51b2\u9500\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        WriteOffCommand command = new WriteOffCommand(oemOrderInsteads);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684OEM\u5de5\u5382\u4ee3\u7801")
    @RequestMapping(value={"service/getOemFactory"})
    @ResponseBody
    public ResponseResult<String> getOemFactory() {
        String oemFactorys = OemOrderItemUtils.getOemFactory().toString();
        return ResponseResult.success((Object)oemFactorys.substring(1, oemFactorys.length() - 1));
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4e14\u53d1\u9001\u4ee3\u6536\u8d27")
    @RequestMapping(value={"service/createAndSend"})
    @ResponseBody
    public ResponseResult<String> createAndSend(@RequestBody List<OemOrderInstead> oemOrderInsteads) {
        CreateAndSendOemInsteadCmd command = new CreateAndSendOemInsteadCmd(oemOrderInsteads);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u8fc7\u8d26\u65f6\u95f4")
    @RequestMapping(value={"service/ModifyPostingTime"})
    @ResponseBody
    public ResponseResult<String> ModifyPostingTime(@RequestBody List<OemOrderInstead> oemOrderInsteads) {
        Assert.isNotEmpty(oemOrderInsteads, (String)"\u4fee\u6539\u8bb0\u5f55\u4e3a\u7a7a");
        ModifyPostingTimeCommand command = new ModifyPostingTimeCommand(oemOrderInsteads);
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    private void saveBatch(List<OemOrderInstead> data) {
        data.stream().forEach(instead -> {
            List<OemOrderInsteadBatch> batches = this.oemOrderInsteadBatchService.queryAllObjByInsteadId(instead.getId());
            List batchNumList = batches.stream().filter(b -> StringUtils.isNotBlank((String)b.getBatchNumber())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(batchNumList)) {
                instead.setBatchList(batches);
            }
        });
    }
}

