/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.oem.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.collection.oem.dao.OemOrderInsteadBatchMapper;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatch;
import com.els.liby.collection.oem.entity.OemOrderInsteadBatchExample;
import com.els.liby.collection.oem.service.OemOrderInsteadBatchService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemOrderInsteadBatchService")
public class OemOrderInsteadBatchServiceImpl
implements OemOrderInsteadBatchService {
    @Resource
    protected OemOrderInsteadBatchMapper oemOrderInsteadBatchMapper;

    @CacheEvict(value={"oemOrderInsteadBatch"}, allEntries=true)
    public void addObj(OemOrderInsteadBatch t) {
        this.oemOrderInsteadBatchMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemOrderInsteadBatch"}, allEntries=true)
    public void addAll(List<OemOrderInsteadBatch> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemOrderInsteadBatchMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemOrderInsteadBatch"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemOrderInsteadBatchMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemOrderInsteadBatch"}, allEntries=true)
    public void deleteByExample(OemOrderInsteadBatchExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemOrderInsteadBatchMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemOrderInsteadBatch"}, allEntries=true)
    public void modifyObj(OemOrderInsteadBatch t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemOrderInsteadBatchMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemOrderInsteadBatch"}, keyGenerator="redisKeyGenerator")
    public OemOrderInsteadBatch queryObjById(String id) {
        return this.oemOrderInsteadBatchMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemOrderInsteadBatch"}, keyGenerator="redisKeyGenerator")
    public List<OemOrderInsteadBatch> queryAllObjByExample(OemOrderInsteadBatchExample example) {
        return this.oemOrderInsteadBatchMapper.selectByExample(example);
    }

    @Cacheable(value={"oemOrderInsteadBatch"}, keyGenerator="redisKeyGenerator")
    public PageView<OemOrderInsteadBatch> queryObjByPage(OemOrderInsteadBatchExample example) {
        PageView<OemOrderInsteadBatch> pageView = example.getPageView();
        pageView.setQueryResult(this.oemOrderInsteadBatchMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"oemOrderInsteadBatch"}, keyGenerator="redisKeyGenerator")
    public List<OemOrderInsteadBatch> queryAllObjByInsteadId(String insteadId) {
        OemOrderInsteadBatchExample example = new OemOrderInsteadBatchExample();
        example.createCriteria().andOemInsteadIdEqualTo(insteadId);
        return this.oemOrderInsteadBatchMapper.selectByExampleByPage(example);
    }

    @Override
    @Cacheable(value={"oemOrderInsteadBatch"}, keyGenerator="redisKeyGenerator")
    public List<OemOrderInsteadBatch> queryBomProductByInsteadId(String insteadId) {
        OemOrderInsteadBatchExample example = new OemOrderInsteadBatchExample();
        example.createCriteria().andOemInsteadIdEqualTo(insteadId).andMaterialCodeLike("8%");
        return this.oemOrderInsteadBatchMapper.selectByExampleByPage(example);
    }
}

