/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.collection.utils;

import com.els.base.common.ContextUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.PurVoucher;
import com.els.base.delivery.entity.PurVoucherExample;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.liby.collection.feed.entity.OemFeedOrderItemExt;
import com.els.liby.collection.feed.service.OemFeedOrderItemExtService;
import com.els.liby.util.OemContextUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public abstract class OemOrderItemUtils {
    private static String BILL_TYPE = "122";

    public static OemFeedOrderItemExt getPurchaseItemExt(String itemId) {
        OemFeedOrderItemExtService service = (OemFeedOrderItemExtService)SpringContextHolder.getOneBean(OemFeedOrderItemExtService.class);
        OemFeedOrderItemExt ext = service.queryByItemId(itemId);
        return ext;
    }

    public static BigDecimal getCanDeliveryQuantity(BigDecimal receivedQuantity, BigDecimal quantity, String orderItemId) {
        OemFeedOrderItemExt ext = OemOrderItemUtils.getPurchaseItemExt(orderItemId);
        if (quantity == null) {
            return BigDecimal.ZERO;
        }
        if (ext == null) {
            return quantity.subtract(receivedQuantity == null ? BigDecimal.ZERO : receivedQuantity);
        }
        return quantity.subtract(receivedQuantity == null ? BigDecimal.ZERO : receivedQuantity).subtract(ext.getSubmittedQuantity() == null ? BigDecimal.ZERO : ext.getSubmittedQuantity()).subtract(ext.getUnsubmittedQuantity() == null ? BigDecimal.ZERO : ext.getUnsubmittedQuantity());
    }

    public static void resolveWapper(PurchaseOrderExample example, QueryParamWapper wapper) {
        if (wapper != null) {
            List lists = wapper.getQueryParams();
            ArrayList orderLists = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)lists)) {
                List items = lists.stream().map(queryParam -> {
                    if ("supCompanyName".equals(queryParam.property) || "orderNo".equals(queryParam.property)) {
                        orderLists.add(queryParam);
                        return null;
                    }
                    return queryParam;
                }).filter(queryParam -> queryParam != null).collect(Collectors.toList());
                wapper.setQueryParams(orderLists);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
                wapper.setQueryParams(items);
            }
        }
    }

    public static List<String> getOrderIdsByType(PurchaseOrderExample example) {
        List lists = OemContextUtils.getPurchaseOrderService().queryAllObjByExample((IExample)example);
        List<String> purOrderIds = lists.stream().map(purchaseOrder -> purchaseOrder.getId()).collect(Collectors.toList());
        return purOrderIds;
    }

    public static PurchaseOrderItem vaidOrderstatus(String orderNo, String orderItemId, BigDecimal deliveryQuantity) {
        PurchaseOrder order = ContextUtils.getPurchaseOrderService().queryByOrderNo(ProjectUtils.getProjectId(), orderNo);
        if (!PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(order.getOrderStatus())) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u672a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u6536\u8d27");
        }
        if ("Y".equals(order.getReturnFlag())) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u5df2\u9000\u8d27\uff0c\u4e0d\u5141\u8bb8\u6536\u8d27");
        }
        if (!Constant.YES_INT.equals(order.getIsEnable())) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u5df2\u5220\u9664\u6216\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u6536\u8d27");
        }
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById((Object)orderItemId);
        if (!PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(purchaseOrderItem.getOrderStatus())) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u884c\u672a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u6536\u8d27");
        }
        if ("Y".equals(purchaseOrderItem.getFinishFlag())) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u884c\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u6536\u8d27");
        }
        BigDecimal canDeliveryQuantity = OemOrderItemUtils.getCanDeliveryQuantity(purchaseOrderItem.getReceivedQuantity(), purchaseOrderItem.getQuantity(), orderItemId);
        if (deliveryQuantity.compareTo(canDeliveryQuantity) > 0) {
            throw new CommonException("\u6536\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u6536\u8d27\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        return purchaseOrderItem;
    }

    public static List<String> getOemFactory() {
        List sapCodes = CompanyUtils.currentCompany().getCompanySapCodeList();
        Assert.isNotEmpty((Collection)sapCodes, (String)"\u8d26\u53f7\u672a\u5173\u8054\u4f9b\u5e94\u5546");
        List<String> oemFactorys = sapCodes.stream().map(code -> code.substring(1, code.length())).collect(Collectors.toList());
        return oemFactorys;
    }

    public static List<PurVoucher> getSapWriteOffVoucherNos(Date startTime, Date endTime) {
        PurVoucherExample example = new PurVoucherExample();
        example.createCriteria().andBillTypeEqualTo(BILL_TYPE).andCreateTimeBetween(startTime, endTime);
        List lists = OemContextUtils.getPurVoucherService().queryAllObjByExample((IExample)example);
        return lists;
    }
}

