/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Constant;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.util.OemContextUtils;
import java.math.BigDecimal;

public class ModifyOemDeliveryOrderIsCanDeliveryCmd
extends AbstractCommand<Void> {
    private static final long serialVersionUID = 1L;
    private String OemDeliveryOrderItemId;

    public ModifyOemDeliveryOrderIsCanDeliveryCmd(String oemDeliveryOrderItemId) {
        this.OemDeliveryOrderItemId = oemDeliveryOrderItemId;
    }

    public Void execute(ICommandInvoker context) {
        OemDeliveryOrderItem deliveryOrderItem = (OemDeliveryOrderItem)OemContextUtils.getOemDeliveryOrderItemService().queryObjById(this.OemDeliveryOrderItemId);
        Integer isCanDelivery = null;
        isCanDelivery = BigDecimal.ZERO.compareTo(deliveryOrderItem.getCanDeliveryQuantity()) >= 0 || Constant.NO_INT.equals(deliveryOrderItem.getIsEnable()) ? Constant.NO_INT : Constant.YES_INT;
        String usedStatus = null;
        usedStatus = this.getUsedStatus(deliveryOrderItem);
        OemDeliveryOrderItem item = new OemDeliveryOrderItem();
        item.setId(this.OemDeliveryOrderItemId);
        item.setIsCanDelivery(isCanDelivery);
        item.setUsedStatus(usedStatus);
        OemContextUtils.getOemDeliveryOrderItemService().modifyObj(item);
        return null;
    }

    private String getUsedStatus(OemDeliveryOrderItem item) {
        String usedStatus = null;
        if (item.getCanDeliveryQuantity().compareTo(item.getQuantity()) == 0) {
            usedStatus = DeliveryPlanUesdStatusEnum.UN_USED.getValue();
        }
        if (item.getCanDeliveryQuantity().compareTo(BigDecimal.ZERO) > 0 && item.getCanDeliveryQuantity().compareTo(item.getQuantity()) < 0) {
            usedStatus = DeliveryPlanUesdStatusEnum.PART_USED.getValue();
        }
        if (item.getCanDeliveryQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            usedStatus = DeliveryPlanUesdStatusEnum.ALL_USED.getValue();
        }
        return usedStatus;
    }
}

