/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.liby.delivery.command.ModifyOemDeliveryOrderIsCanDeliveryCmd;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.util.OemContextUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyOemDeliveryOrderOnWayQuantityCmd
extends AbstractCommand<String> {
    public static Logger logger = LoggerFactory.getLogger(ModifyOemDeliveryOrderOnWayQuantityCmd.class);
    private String OemDeliveryOrderItemId;
    private BigDecimal deliveryQuantity;

    public ModifyOemDeliveryOrderOnWayQuantityCmd(String oemDeliveryOrderItemId, BigDecimal deliveryQuantity) {
        Assert.isNotBlank((String)oemDeliveryOrderItemId, (String)"\u53d1\u8d27\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deliveryQuantity, (String)"\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        this.OemDeliveryOrderItemId = oemDeliveryOrderItemId;
        this.deliveryQuantity = deliveryQuantity;
    }

    public String execute(ICommandInvoker context) {
        logger.info("EVENT=\u4fee\u6539OEM\u53d1\u8d27\u5355\u884c\u7684\u53d1\u8d27\u6570|OemDeliveryOrderItemId={}|\u53d8\u66f4\u6570\u91cf={}", (Object)this.OemDeliveryOrderItemId, (Object)this.deliveryQuantity);
        OemDeliveryOrderItem deliveryOrderItem = (OemDeliveryOrderItem)OemContextUtils.getOemDeliveryOrderItemService().queryObjById(this.OemDeliveryOrderItemId);
        Assert.isNotNull((Object)deliveryOrderItem, (String)"OEM\u53d1\u8d27\u5355\u884c\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        this.subtractQuantity(deliveryOrderItem, this.deliveryQuantity);
        this.updatIsCanDelivery(this.OemDeliveryOrderItemId);
        return null;
    }

    private void updatIsCanDelivery(String oemDeliveryOrderItemId) {
        ModifyOemDeliveryOrderIsCanDeliveryCmd cmd = new ModifyOemDeliveryOrderIsCanDeliveryCmd(this.OemDeliveryOrderItemId);
        this.context.invoke((AbstractCommand)cmd);
    }

    private void subtractQuantity(OemDeliveryOrderItem supPlanItem, BigDecimal deliveryQuantity) {
        OemContextUtils.getOemDeliveryOrderItemService().addOnwayQuantity(supPlanItem.getId(), deliveryQuantity);
    }
}

