/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryInstead;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.delivery.command.ModifyOemDeliveryOrderOnWayQuantityCmd;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.util.GetVoucherNoUtil;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemReceivingStatusEnum;
import com.els.liby.util.OemSendStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BatchCreateDeliveryInsteadCmd
extends AbstractCommand<List<OemDeliveryInstead>> {
    private List<OemDeliveryInstead> oemDeliveryInsteads;

    public BatchCreateDeliveryInsteadCmd(List<OemDeliveryInstead> oemDeliveryInsteads) {
        this.oemDeliveryInsteads = oemDeliveryInsteads;
    }

    public List<OemDeliveryInstead> execute(ICommandInvoker context) {
        this.vaild(this.oemDeliveryInsteads);
        this.init(this.oemDeliveryInsteads);
        this.updateOnwayQuantity(this.oemDeliveryInsteads);
        OemContextUtils.getOemDeliveryInsteadService().addAll(this.oemDeliveryInsteads);
        return this.oemDeliveryInsteads;
    }

    private void updateOnwayQuantity(List<OemDeliveryInstead> oemDeliveryInsteads) {
        oemDeliveryInsteads.stream().forEach(oemDeliveryInstead -> {
            ModifyOemDeliveryOrderOnWayQuantityCmd cmd = new ModifyOemDeliveryOrderOnWayQuantityCmd(oemDeliveryInstead.getDeliveryOrderItemId(), oemDeliveryInstead.getDeliveryQuantity());
            this.context.invoke((AbstractCommand)cmd);
        });
    }

    private void vaild(List<OemDeliveryInstead> oemDeliveryInsteads) {
        oemDeliveryInsteads.stream().forEach(oemDeliveryInstead -> {
            Assert.isNotBlank((String)oemDeliveryInstead.getDeliveryBatchNo(), (String)MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u4ea4\u8d27\u6279\u6b21\u4e3a\u7a7a", oemDeliveryInstead.getDeliveryOrderNo(), oemDeliveryInstead.getDeliveryOrderItemNo()));
            if (oemDeliveryInstead.getDeliveryBatchNo().length() > 10) {
                throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u4ea4\u8d27\u6279\u6b21\u957f\u5ea6\u5927\u4e8e10", oemDeliveryInstead.getDeliveryOrderNo(), oemDeliveryInstead.getDeliveryOrderItemNo()));
            }
            if (oemDeliveryInstead.getDeliveryQuantity() == null || BigDecimal.ZERO.compareTo(oemDeliveryInstead.getDeliveryQuantity()) == 0) {
                throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u4ea4\u8d27\u6570\u91cf\u4e3a\u7a7a", oemDeliveryInstead.getDeliveryOrderNo(), oemDeliveryInstead.getDeliveryOrderItemNo()));
            }
        });
    }

    private void init(List<OemDeliveryInstead> oemDeliveryInsteads) {
        Map<String, List<OemDeliveryInstead>> map = oemDeliveryInsteads.stream().collect(Collectors.groupingBy(OemDeliveryInstead::getDeliveryOrderItemId));
        map.entrySet().forEach(entry -> {
            String deliveryOrderItemId = (String)entry.getKey();
            List groupInsteads = (List)entry.getValue();
            OemDeliveryOrderItem item = (OemDeliveryOrderItem)OemContextUtils.getOemDeliveryOrderItemService().queryObjById(deliveryOrderItemId);
            groupInsteads.stream().forEach(oemDeliveryInstead -> this.buildIndtead((OemDeliveryInstead)oemDeliveryInstead, item));
            BigDecimal deliveryQuantityTotal = groupInsteads.stream().map(OemDeliveryInstead::getDeliveryQuantity).reduce((x, y) -> x.add((BigDecimal)y)).get();
            if (deliveryQuantityTotal.compareTo(item.getCanDeliveryQuantity()) > 0) {
                throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u4ea4\u8d27\u6570\u91cf\u5927\u4e8e\u53d1\u8d27\u5355\u53ef\u53d1\u8d27\u6570\u91cf{2}", item.getDeliveryOrderNo(), item.getDeliveryOrderItemNo(), item.getCanDeliveryQuantity()));
            }
        });
    }

    private void buildIndtead(OemDeliveryInstead oemDeliveryInstead, OemDeliveryOrderItem item) {
        oemDeliveryInstead.setId(UUIDGenerator.generateUUID());
        oemDeliveryInstead.setInsteadVoucherNo(GetVoucherNoUtil.getOemDeliveryVoucher(item.getDeliveryFactory()));
        oemDeliveryInstead.setInsteadVoucherItemNo("1");
        oemDeliveryInstead.setMaterialId(item.getMaterialId());
        oemDeliveryInstead.setDeliveryOrderId(item.getDeliveryOrderId());
        oemDeliveryInstead.setQuantity(item.getQuantity());
        oemDeliveryInstead.setUnit(item.getUnit());
        oemDeliveryInstead.setExpectDeliveryTime(item.getExpectDeliveryTime());
        oemDeliveryInstead.setExpectArriveTime(item.getExpectArriveTime());
        oemDeliveryInstead.setDeliveryFactory(item.getDeliveryFactory());
        oemDeliveryInstead.setDeliveryFactoryName(item.getDeliveryFactoryName());
        oemDeliveryInstead.setDeliveryStorehouse(item.getDeliveryStorehouse());
        oemDeliveryInstead.setDeliveryStorehouseDesc(item.getDeliveryStorehouseDesc());
        oemDeliveryInstead.setDeliveryCompanyId(item.getDeliveryCompanyId());
        oemDeliveryInstead.setDeliveryCompanySapCode(item.getDeliveryCompanySapCode());
        oemDeliveryInstead.setDeliveryCompanySrmCode(item.getDeliveryCompanySrmCode());
        oemDeliveryInstead.setDeliveryCompanyName(item.getDeliveryCompanyName());
        oemDeliveryInstead.setAllotOrderType(item.getAllotOrderType());
        oemDeliveryInstead.setReceivingFactory(item.getReceivingFactory());
        oemDeliveryInstead.setReceivingFactoryName(item.getReceivingFactoryName());
        oemDeliveryInstead.setReceivingStorehouse(item.getReceivingStorehouse());
        oemDeliveryInstead.setReceivingStorehouseDesc(item.getReceivingStorehouseDesc());
        oemDeliveryInstead.setReceivingCompanyId(item.getReceivingCompanyId());
        oemDeliveryInstead.setReceivingCompanySapCode(item.getReceivingCompanySapCode());
        oemDeliveryInstead.setReceivingCompanySrmCode(item.getReceivingCompanySrmCode());
        oemDeliveryInstead.setReceivingCompanyName(item.getReceivingCompanyName());
        oemDeliveryInstead.setTransferOrderNo(item.getTransferOrderNo());
        oemDeliveryInstead.setTransferOrderItemNo(item.getTransferOrderItemNo());
        oemDeliveryInstead.setCreateTime(new Date());
        oemDeliveryInstead.setCreateUserId(this.getSupUser().getId());
        oemDeliveryInstead.setCreateUserName(this.getSupUser().getNickName());
        oemDeliveryInstead.setUpdateTime(new Date());
        oemDeliveryInstead.setUpdateUserId(this.getSupUser().getId());
        oemDeliveryInstead.setUpdateUserName(this.getSupUser().getNickName());
        oemDeliveryInstead.setSendStatus(OemSendStatusEnum.UNSUBMITTED.getValue());
        oemDeliveryInstead.setConfirmStatus(OemConfirmStatusEnum.UNCOLLECTED.getValue());
        oemDeliveryInstead.setWriteoffFlag(OemWriteOffEnum.UN_WRITE_OFF.getValue());
        oemDeliveryInstead.setReceivingStatus(OemReceivingStatusEnum.UNRECEIVE.getValue());
    }
}

