/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryInstead;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.liby.delivery.command.ModifyOemDeliveryOrderReceiveQuantityCmd;
import com.els.liby.delivery.command.deliveryInstead.CollectedBackSapCommand;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CollectedCommand
extends AbstractCommand<Integer> {
    private List<OemDeliveryInstead> oemDeliveryInsteads;

    public CollectedCommand(List<OemDeliveryInstead> oemDeliveryInsteads) {
        this.oemDeliveryInsteads = oemDeliveryInsteads;
    }

    public Integer execute(ICommandInvoker context) {
        this.vaildStatus(this.oemDeliveryInsteads);
        List<OemDeliveryInstead> effectiveInsteads = this.getEffectiveInsteadsByOrderStatus(this.oemDeliveryInsteads);
        this.vaidQuantity(effectiveInsteads);
        CollectedBackSapCommand command = new CollectedBackSapCommand(effectiveInsteads);
        List codes = (List)context.invoke((AbstractCommand)command);
        List collectedSuccessInstead = effectiveInsteads.stream().filter(o -> codes.contains(o.getInsteadVoucherNo())).collect(Collectors.toList());
        collectedSuccessInstead.stream().forEach(instead -> {
            ModifyOemDeliveryOrderReceiveQuantityCmd cmd = new ModifyOemDeliveryOrderReceiveQuantityCmd(instead.getDeliveryOrderItemId(), instead.getDeliveryQuantity());
            context.invoke((AbstractCommand)cmd);
        });
        return collectedSuccessInstead.size();
    }

    private void vaidQuantity(List<OemDeliveryInstead> effectiveInsteads) {
        Map<String, List<OemDeliveryInstead>> DeliveryOrderNoMap = effectiveInsteads.stream().collect(Collectors.groupingBy(instead -> instead.getDeliveryOrderNo()));
        DeliveryOrderNoMap.forEach((orderNo, values) -> {
            List<String> ItemNos = OemContextUtils.getOemDeliveryOrderItemService().queryItemNoByOrderNo((String)orderNo);
            Map<String, List<OemDeliveryInstead>> map = values.stream().collect(Collectors.groupingBy(instead -> instead.getDeliveryOrderItemNo()));
            map.forEach((k, v) -> {
                if (!ItemNos.contains(k)) {
                    throw new CommonException(MessageFormat.format("\u53d1\u8d27\u5355\u9700\u6574\u5355\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\uff1a{0}\uff0c\u7f3a\u5c11\u884c{1}", orderNo, k));
                }
                BigDecimal deliveryQuantity = v.stream().map(OemDeliveryInstead::getDeliveryQuantity).reduce((x, y) -> x.add((BigDecimal)y)).get();
                if (((OemDeliveryInstead)v.get(0)).getQuantity().compareTo(deliveryQuantity) != 0) {
                    throw new CommonException(MessageFormat.format("\u51fa\u8d27\u6570\u91cf\u4e0e\u53d1\u8d27\u5355\uff1a{0}\uff0c\u884c{1} \u8981\u6c42\u6570\u91cf\u4e0d\u540c", orderNo, k));
                }
            });
        });
    }

    private List<OemDeliveryInstead> getEffectiveInsteadsByOrderStatus(List<OemDeliveryInstead> oemDeliveryInsteads) {
        List<OemDeliveryInstead> list = oemDeliveryInsteads.stream().filter(o -> {
            OemDeliveryOrderItem item = (OemDeliveryOrderItem)OemContextUtils.getOemDeliveryOrderItemService().queryObjById(o.getDeliveryOrderItemId());
            if (Constant.NO_INT.equals(item.getIsEnable())) {
                OemDeliveryInstead instead = new OemDeliveryInstead();
                instead.setId(o.getId());
                instead.setConfirmStatus(OemConfirmStatusEnum.COLLECTED_FAIL.getValue());
                instead.setConfirmFailReason(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u5df2\u5220\u9664", o.getDeliveryOrderNo(), o.getDeliveryOrderItemNo()));
                OemContextUtils.getOemDeliveryInsteadService().modifyObj(instead);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return list;
    }

    private void vaildStatus(List<OemDeliveryInstead> oemDeliveryInsteads) {
        oemDeliveryInsteads.stream().forEach(o -> {
            OemDeliveryInstead initialData = (OemDeliveryInstead)OemContextUtils.getOemDeliveryInsteadService().queryObjById(o.getId());
            if (initialData.getConfirmStatus().equals(OemConfirmStatusEnum.COLLECTED.getValue())) {
                throw new CommonException(MessageFormat.format("\u63d0\u4ea4\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a{0}\uff1b\u5df2\u786e\u8ba4", o.getInsteadVoucherNo()));
            }
            if (!initialData.getWriteoffFlag().equals(OemWriteOffEnum.UN_WRITE_OFF.getValue())) {
                throw new CommonException(MessageFormat.format("\u63d0\u4ea4\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a{0}\uff1b\u5df2\u51b2\u9500", o.getInsteadVoucherNo()));
            }
        });
    }
}

