/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryInstead;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.delivery.entity.PurVoucher;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.delivery.command.ModifyOemDeliveryOrderReceiveQuantityCmd;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.delivery.entity.OemDeliveryInsteadExample;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DeliveryWriteOffByAspCommand
extends AbstractCommand {
    private Date startTime;
    private Date endTime;

    public DeliveryWriteOffByAspCommand(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Object execute(ICommandInvoker context) {
        List<PurVoucher> purVouchers = OemOrderItemUtils.getSapWriteOffVoucherNos(this.startTime, this.endTime);
        for (PurVoucher voucher : purVouchers) {
            this.writeOffFeed(voucher);
        }
        return null;
    }

    private void writeOffFeed(PurVoucher voucher) {
        if (StringUtils.isBlank((String)voucher.getMaterialVoucherNo())) {
            return;
        }
        OemDeliveryInsteadExample example = new OemDeliveryInsteadExample();
        example.createCriteria().andSapVoucherNoEqualTo(voucher.getMaterialVoucherNo());
        List list = OemContextUtils.getOemDeliveryInsteadService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        OemDeliveryInstead instead = new OemDeliveryInstead();
        instead.setWriteoffFlag(OemWriteOffEnum.SAP_WRITE_OFF.getValue());
        instead.setWriteoffDate(voucher.getVoucherTime());
        OemContextUtils.getOemDeliveryInsteadService().modifybyExample(instead, example);
        ModifyOemDeliveryOrderReceiveQuantityCmd cmd = new ModifyOemDeliveryOrderReceiveQuantityCmd(((OemDeliveryInstead)list.get(0)).getDeliveryOrderItemId(), BigDecimal.ZERO.subtract(((OemDeliveryInstead)list.get(0)).getDeliveryQuantity()));
        this.context.invoke((AbstractCommand)cmd);
    }
}

