/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryInstead;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.liby.delivery.command.ModifyOemDeliveryOrderOnWayQuantityCmd;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

public class ModifyDeliveryInsteadCmd
extends AbstractCommand<List<OemDeliveryInstead>> {
    private OemDeliveryInstead oemDeliveryInstead;

    public ModifyDeliveryInsteadCmd(OemDeliveryInstead oemDeliveryInstead) {
        this.oemDeliveryInstead = oemDeliveryInstead;
    }

    public List<OemDeliveryInstead> execute(ICommandInvoker context) {
        OemDeliveryInstead initialData = (OemDeliveryInstead)OemContextUtils.getOemDeliveryInsteadService().queryObjById(this.oemDeliveryInstead.getId());
        OemDeliveryOrderItem item = (OemDeliveryOrderItem)OemContextUtils.getOemDeliveryOrderItemService().queryObjById(this.oemDeliveryInstead.getDeliveryOrderItemId());
        this.init(this.oemDeliveryInstead);
        this.vaild(this.oemDeliveryInstead, initialData, item);
        this.updateOnwayQuantity(this.oemDeliveryInstead, initialData);
        OemContextUtils.getOemDeliveryInsteadService().modifyObj(this.oemDeliveryInstead);
        return null;
    }

    private void updateOnwayQuantity(OemDeliveryInstead o, OemDeliveryInstead initialData) {
        ModifyOemDeliveryOrderOnWayQuantityCmd cmd = new ModifyOemDeliveryOrderOnWayQuantityCmd(o.getDeliveryOrderItemId(), o.getDeliveryQuantity().subtract(initialData.getDeliveryQuantity()));
        this.context.invoke((AbstractCommand)cmd);
    }

    private void vaild(OemDeliveryInstead o, OemDeliveryInstead initialData, OemDeliveryOrderItem item) {
        if (initialData.getConfirmStatus().equals(OemConfirmStatusEnum.COLLECTED.getValue())) {
            throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u5df2\u786e\u8ba4", o.getDeliveryOrderNo(), o.getDeliveryOrderItemNo()));
        }
        if (!initialData.getWriteoffFlag().equals(OemWriteOffEnum.UN_WRITE_OFF.getValue())) {
            throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u5df2\u51b2\u9500", o.getDeliveryOrderNo(), o.getDeliveryOrderItemNo()));
        }
        if (Constant.NO_INT.equals(item.getIsEnable())) {
            throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u5df2\u5220\u9664", o.getDeliveryOrderNo(), o.getDeliveryOrderItemNo()));
        }
        Assert.isNotBlank((String)o.getDeliveryBatchNo(), (String)MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u4ea4\u8d27\u6279\u6b21\u4e3a\u7a7a", o.getDeliveryOrderNo(), o.getDeliveryOrderItemNo()));
        if (o.getDeliveryQuantity() == null || BigDecimal.ZERO.compareTo(item.getCanDeliveryQuantity().add(initialData.getDeliveryQuantity())) == 0) {
            throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u4ea4\u8d27\u6570\u91cf\u4e3a\u7a7a", o.getDeliveryOrderNo(), o.getDeliveryOrderItemNo()));
        }
        if (o.getDeliveryQuantity().compareTo(item.getCanDeliveryQuantity().add(initialData.getDeliveryQuantity())) > 0) {
            throw new CommonException(MessageFormat.format("\u4ea4\u8d27\u5355\uff1a{0}\uff0c{1}\u884c\u4ea4\u8d27\u6570\u91cf\u5927\u4e8e\u53d1\u8d27\u5355\u53ef\u53d1\u8d27\u6570\u91cf{2}", item.getDeliveryOrderNo(), item.getDeliveryOrderItemNo(), item.getCanDeliveryQuantity().add(initialData.getDeliveryQuantity())));
        }
    }

    private void init(OemDeliveryInstead oemDeliveryInstead) {
        oemDeliveryInstead.setUpdateTime(new Date());
        oemDeliveryInstead.setUpdateUserId(this.getSupUser().getId());
        oemDeliveryInstead.setUpdateUserName(this.getSupUser().getNickName());
        oemDeliveryInstead.setConfirmStatus(OemConfirmStatusEnum.RETURN_BACK.getValue());
    }
}

