/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryInstead;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.liby.delivery.command.ModifyOemDeliveryOrderOnWayQuantityCmd;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.delivery.entity.OemDeliveryInsteadExample;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemWriteOffEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class WriteOffCommand
extends AbstractCommand {
    private List<OemDeliveryInstead> oemDeliveryInsteads;

    public WriteOffCommand(List<OemDeliveryInstead> oemDeliveryInsteads) {
        this.oemDeliveryInsteads = oemDeliveryInsteads;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemDeliveryInsteads);
        List ids = this.oemDeliveryInsteads.stream().map(o -> o.getId()).collect(Collectors.toList());
        OemDeliveryInsteadExample example = new OemDeliveryInsteadExample();
        example.createCriteria().andIdIn(ids);
        OemDeliveryInstead instead = new OemDeliveryInstead();
        instead.setWriteoffFlag(OemWriteOffEnum.SRM_WRITE_OFF.getValue());
        instead.setWriteoffDate(new Date());
        instead.setWriteoffUserId(this.getSupUser().getId());
        instead.setWriteoffUserName(this.getSupUser().getNickName());
        OemContextUtils.getOemDeliveryInsteadService().modifybyExample(instead, example);
        this.oemDeliveryInsteads.stream().forEach(o -> {
            ModifyOemDeliveryOrderOnWayQuantityCmd cmd = new ModifyOemDeliveryOrderOnWayQuantityCmd(o.getDeliveryOrderItemId(), BigDecimal.ZERO.subtract(o.getDeliveryQuantity()));
            context.invoke((AbstractCommand)cmd);
        });
        return null;
    }

    private void vaidStatus(List<OemDeliveryInstead> oemDeliveryInsteads) {
        oemDeliveryInsteads.stream().forEach(o -> {
            if (OemConfirmStatusEnum.COLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u51b2\u9500\u5931\u8d25\uff1b\u4ee3\u53d1\u8d27\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadVoucherNo() + "\uff1b\u5df2\u786e\u8ba4");
            }
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(o.getWriteoffFlag())) {
                throw new CommonException("\u51b2\u9500\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getInsteadVoucherNo() + "\uff1b\u5df2\u51b2\u9500");
            }
        });
    }
}

