/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryOrder;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.liby.delivery.entity.OemDeliveryOrder;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.delivery.shipment.entity.OemShipment;
import com.els.liby.util.OemContextUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOemDeliveryOrderItemCmd
extends AbstractCommand {
    private static final Logger log = LoggerFactory.getLogger(CreateOemDeliveryOrderItemCmd.class);
    private List<OemDeliveryOrderItem> orderItemList;
    private OemDeliveryOrder order;

    public CreateOemDeliveryOrderItemCmd(List<OemDeliveryOrderItem> orderItemList, OemDeliveryOrder order) {
        this.orderItemList = orderItemList;
        this.order = order;
    }

    public Object execute(ICommandInvoker context) {
        this.valid();
        List<OemDeliveryOrderItem> items = this.init(this.orderItemList);
        log.info(MessageFormat.format("EVENT\uff1a\u53d1\u8d27\u5355\u660e\u7ec6\u65b0\u589e\uff0c\u660e\u7ec6\u6570\u636e{0}\uff0c\u6709\u6548\u6570\u636e{1}\u6761", this.orderItemList.size(), items.size()));
        OemContextUtils.getOemDeliveryOrderItemService().addAll(items);
        return null;
    }

    private List<OemDeliveryOrderItem> init(List<OemDeliveryOrderItem> orderItems) {
        List<OemDeliveryOrderItem> items = orderItems.stream().filter(item -> {
            OemShipment deliveryCompany = this.getShipment(item.getDeliveryFactory(), item.getDeliveryStorehouse(), this.order.getShipmentDesc());
            if (deliveryCompany == null) {
                log.info(MessageFormat.format("\u53d1\u51fa\u5de5\u5382{0}\uff0c\u53d1\u51fa\u5e93\u5b58\u5730\u70b9{1}\uff0c\u88c5\u8fd0\u70b9{2}\u4e0d\u5b58\u5728\u4f9b\u5e94\u5546", item.getDeliveryFactory(), item.getDeliveryStorehouse(), this.order.getShipmentDesc()));
                return false;
            }
            OemShipment receivingCompany = null;
            if (StringUtils.isNotBlank((String)item.getReceivingStorehouse()) && (receivingCompany = this.getShipment(item.getReceivingFactory(), item.getReceivingStorehouse(), this.order.getShipmentDesc())) == null) {
                log.info(MessageFormat.format("\u63a5\u6536\u5de5\u5382{0}\uff0c\u63a5\u6536\u5e93\u5b58\u5730\u70b9{1}\uff0c\u88c5\u8fd0\u70b9{2}\u4e0d\u5b58\u5728\u4f9b\u5e94\u5546", item.getReceivingFactory(), item.getReceivingStorehouse(), this.order.getShipmentDesc()));
                return false;
            }
            this.buildItem((OemDeliveryOrderItem)item, deliveryCompany, receivingCompany, this.order);
            return true;
        }).collect(Collectors.toList());
        return items;
    }

    private OemShipment getShipment(String deliveryFactory, String stockSpaceCode, String shipmentDesc) {
        return OemContextUtils.getOemShipmentService().findByFactoryAndShipmentCode(deliveryFactory, stockSpaceCode, shipmentDesc);
    }

    private void buildItem(OemDeliveryOrderItem item, OemShipment deliveryCompany, OemShipment receivingCompany, OemDeliveryOrder order) {
        item.setUsedStatus(DeliveryPlanUesdStatusEnum.UN_USED.getValue());
        item.setDeliveryOrderId(order.getId());
        item.setDeliveryOrderNo(order.getDeliveryOrderNo());
        item.setDeliveryOrderType(order.getDeliveryOrderType());
        item.setCustomerType(order.getCustomerType());
        item.setCustomerDesc(order.getCustomerDesc());
        item.setCustomerCode(order.getCustomerCode());
        item.setCustomerName(order.getCustomerName());
        item.setDcStorehouse(order.getDcStorehouse());
        item.setShipmentId(order.getShipmentId());
        item.setShipmentCode(order.getShipmentCode());
        item.setShipmentDesc(order.getShipmentDesc());
        item.setReceivingAddress(item.getReceivingCity());
        item.setReceivingCity(order.getReceivingCity());
        item.setReceiver(order.getReceiver());
        item.setReceivingPhone(order.getReceivingPhone());
        item.setExpectArriveTime(order.getExpectArriveTime());
        item.setExpectDeliveryTime(order.getExpectDeliveryTime());
        item.setPostingType(order.getPostingType());
        item.setDeliveryCompanyId(deliveryCompany.getCompanyId());
        item.setDeliveryCompanySapCode(deliveryCompany.getCompanySapCode());
        item.setDeliveryCompanySrmCode(deliveryCompany.getCompanySrmCode());
        item.setDeliveryCompanyName(deliveryCompany.getCompanyName());
        if (receivingCompany != null) {
            item.setReceivingCompanyId(receivingCompany.getCompanyId());
            item.setReceivingCompanySapCode(receivingCompany.getCompanySapCode());
            item.setReceivingCompanySrmCode(receivingCompany.getCompanySrmCode());
            item.setReceivingCompanyName(receivingCompany.getCompanyName());
        }
        item.setIsEnable(order.getIsEnable());
        item.setIsCanDelivery(order.getIsEnable().equals(Constant.YES_INT) ? Constant.YES_INT : Constant.NO_INT);
        item.setCreateTime(new Date());
        item.setCreateUserId(order.getCreateUserId());
        item.setCreateUserName(order.getCreateUserName());
        item.setOnwayQuantity(BigDecimal.ZERO);
        item.setReceivedQuantity(BigDecimal.ZERO);
    }

    private void valid() {
        Assert.isNotBlank((String)this.order.getId(), (String)"\u53d1\u8d27\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderItemList.stream().forEach(item -> {
            Assert.isNotBlank((String)item.getDeliveryOrderItemNo(), (String)"\u53d1\u8d27\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getDeliveryFactory(), (String)"\u53d1\u8d27\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getDeliveryStorehouse(), (String)"\u53d1\u51fa\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getMaterialCode(), (String)"\u7269\u6599\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getMaterialName(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getQuantity(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getLastUpdateTime(), (String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        });
    }
}

