/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryOrder;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.delivery.util.OemDeliveryExeclUtil;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.time.DateFormatUtils;

public class ExportOemDeliveryItemCommand
extends AbstractCommand {
    private String fileName;
    private List<OemDeliveryOrderItem> data;
    private HttpServletResponse response;

    public ExportOemDeliveryItemCommand(String fileName, List<OemDeliveryOrderItem> data, HttpServletResponse response) {
        this.fileName = fileName;
        this.data = data;
        this.response = response;
    }

    public Object execute(ICommandInvoker context) {
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            this.response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode(MessageFormat.format(this.fileName + "-{0}.xls", dateStr), "UTF-8") + "\";");
            this.response.setHeader("Content-Disposition", header.toString());
            this.response.setCharacterEncoding("UTF-8");
            this.response.setContentType("application/x-msdownload;");
            List<TitleAndModelKey> titleAndModelKeys = OemDeliveryExeclUtil.getTitleAndModelKeys();
            ServletOutputStream outputStream = this.response.getOutputStream();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, this.data, (String)this.fileName, null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        return null;
    }
}

