/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryOrder;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.liby.delivery.command.deliveryOrder.CreateOemDeliveryOrderCommand;
import com.els.liby.delivery.command.deliveryOrder.ModifyOemDeliveryOrderCommand;
import com.els.liby.delivery.entity.OemDeliveryOrder;
import com.els.liby.delivery.entity.OemDeliveryOrderExample;
import com.els.liby.util.OemContextUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ImportOemDeliveryOrderCmd
extends AbstractCommand {
    private List<OemDeliveryOrder> oemDeliveryOrderList;

    public ImportOemDeliveryOrderCmd(List<OemDeliveryOrder> oemDeliveryOrderList) {
        this.oemDeliveryOrderList = oemDeliveryOrderList;
    }

    public Object execute(ICommandInvoker context) {
        if (CollectionUtils.isEmpty(this.oemDeliveryOrderList)) {
            return null;
        }
        for (OemDeliveryOrder order : this.oemDeliveryOrderList) {
            AbstractCommand command;
            OemDeliveryOrder existDeliveryOder = this.queryExistOrder(order);
            if (existDeliveryOder == null) {
                command = new CreateOemDeliveryOrderCommand(order);
                command.copyProperties((AbstractCommand)this);
                context.invoke(command);
                continue;
            }
            order.setId(existDeliveryOder.getId());
            command = new ModifyOemDeliveryOrderCommand(order);
            command.copyProperties((AbstractCommand)this);
            context.invoke(command);
        }
        return null;
    }

    private OemDeliveryOrder queryExistOrder(OemDeliveryOrder order) {
        if (StringUtils.isNotBlank((String)order.getId())) {
            return (OemDeliveryOrder)OemContextUtils.getOemDeliveryOrderService().queryObjById(order.getId());
        }
        OemDeliveryOrderExample example = new OemDeliveryOrderExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(order.getDeliveryOrderNo());
        List list = OemContextUtils.getOemDeliveryOrderService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new CommonException(String.format("OEM\u53d1\u8d27\u5355[%s]\u5728\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u91cd\u590d\u60c5\u51b5", order.getDeliveryOrderNo()));
        }
        return (OemDeliveryOrder)list.get(0);
    }
}

