/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryOrder;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.liby.delivery.command.deliveryOrder.CreateOemDeliveryOrderItemCmd;
import com.els.liby.delivery.command.deliveryOrder.ModifyOemDeliveryOrderItemCmd;
import com.els.liby.delivery.entity.OemDeliveryOrder;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.util.OemContextUtils;
import java.util.ArrayList;
import java.util.List;

public class ModifyOemDeliveryOrderCommand
extends AbstractCommand {
    private OemDeliveryOrder order;

    public ModifyOemDeliveryOrderCommand(OemDeliveryOrder order) {
        this.order = order;
    }

    public Object execute(ICommandInvoker context) {
        this.valid();
        this.init(this.order);
        this.updateDeliveryOrderItem(this.order.getItems());
        OemContextUtils.getOemDeliveryOrderService().modifyObj(this.order);
        return null;
    }

    private void updateDeliveryOrderItem(List<OemDeliveryOrderItem> items) {
        ArrayList<OemDeliveryOrderItem> unExistItem = new ArrayList<OemDeliveryOrderItem>();
        for (OemDeliveryOrderItem item : items) {
            OemDeliveryOrderItem exsitItem = OemContextUtils.getOemDeliveryOrderItemService().queryObjByItemNoAndOrderNo(this.order.getDeliveryOrderNo(), item.getDeliveryOrderItemNo());
            if (exsitItem == null) {
                unExistItem.add(item);
                continue;
            }
            item.setId(exsitItem.getId());
            item.setOnwayQuantity(exsitItem.getOnwayQuantity());
            item.setReceivedQuantity(exsitItem.getReceivedQuantity());
            ModifyOemDeliveryOrderItemCmd cmd = new ModifyOemDeliveryOrderItemCmd(item, this.order);
            this.context.invoke((AbstractCommand)cmd);
        }
        CreateOemDeliveryOrderItemCmd cmd = new CreateOemDeliveryOrderItemCmd(unExistItem, this.order);
        this.context.invoke((AbstractCommand)cmd);
    }

    private void init(OemDeliveryOrder order) {
        if (order.getExpectDeliveryTime() == null) {
            order.setIsEnable(Constant.NO_INT);
        } else {
            order.setIsEnable(Constant.YES_INT);
        }
    }

    private void valid() {
        Assert.isNotBlank((String)this.order.getDeliveryOrderNo(), (String)"\u53d1\u8d27\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getShipmentCode(), (String)"\u88c5\u8fd0\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getShipmentDesc(), (String)"\u88c5\u8fd0\u70b9\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getCustomerType(), (String)"\u5ba2\u6236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getCustomerCode(), (String)"\u5ba2\u6236\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.order.getExpectArriveTime(), (String)"\u8ba1\u5212\u5230\u8d27\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getPostingType(), (String)"\u53d1\u8d27\u8fc7\u8d26\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

