/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.command.deliveryOrder;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.liby.delivery.entity.OemDeliveryOrder;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.delivery.shipment.entity.OemShipment;
import com.els.liby.util.OemContextUtils;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public class ModifyOemDeliveryOrderItemCmd
extends AbstractCommand {
    private OemDeliveryOrderItem orderItem;
    private OemDeliveryOrder order;

    public ModifyOemDeliveryOrderItemCmd(OemDeliveryOrderItem orderItem, OemDeliveryOrder order) {
        this.orderItem = orderItem;
        this.order = order;
    }

    public Object execute(ICommandInvoker context) {
        this.valid();
        this.init(this.orderItem);
        OemContextUtils.getOemDeliveryOrderItemService().modifyObj(this.orderItem);
        return null;
    }

    private void init(OemDeliveryOrderItem item) {
        item.setDeliveryOrderId(this.order.getId());
        item.setDeliveryOrderNo(this.order.getDeliveryOrderNo());
        item.setDeliveryOrderType(this.order.getDeliveryOrderType());
        item.setCustomerType(this.order.getCustomerType());
        item.setCustomerDesc(this.order.getCustomerDesc());
        item.setCustomerCode(this.order.getCustomerCode());
        item.setCustomerName(this.order.getCustomerName());
        item.setDcStorehouse(this.order.getDcStorehouse());
        item.setShipmentId(this.order.getShipmentId());
        item.setShipmentCode(this.order.getShipmentCode());
        item.setShipmentDesc(this.order.getShipmentDesc());
        item.setReceivingAddress(item.getReceivingCity());
        item.setReceivingCity(this.order.getReceivingCity());
        item.setReceiver(this.order.getReceiver());
        item.setReceivingPhone(this.order.getReceivingPhone());
        item.setExpectArriveTime(this.order.getExpectArriveTime());
        item.setExpectDeliveryTime(this.order.getExpectDeliveryTime());
        item.setPostingType(this.order.getPostingType());
        item.setIsEnable(this.order.getIsEnable());
        if (Constant.NO_INT.equals(this.order.getIsEnable())) {
            item.setIsCanDelivery(Constant.NO_INT);
        } else if (item.getCanDeliveryQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            item.setIsCanDelivery(Constant.NO_INT);
        }
        if (item.getCanDeliveryQuantity().compareTo(item.getQuantity()) == 0) {
            item.setUsedStatus(DeliveryPlanUesdStatusEnum.UN_USED.getValue());
        }
        if (item.getCanDeliveryQuantity().compareTo(BigDecimal.ZERO) > 0 && item.getCanDeliveryQuantity().compareTo(item.getQuantity()) < 0) {
            item.setUsedStatus(DeliveryPlanUesdStatusEnum.PART_USED.getValue());
        }
        if (item.getCanDeliveryQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            item.setUsedStatus(DeliveryPlanUesdStatusEnum.ALL_USED.getValue());
        }
        OemShipment receivingCompany = null;
        if (StringUtils.isNotBlank((String)item.getReceivingStorehouse())) {
            receivingCompany = OemContextUtils.getOemShipmentService().findByFactoryAndShipmentCode(item.getReceivingFactory(), item.getReceivingStorehouse(), this.order.getShipmentDesc());
        }
        if (receivingCompany != null) {
            item.setReceivingCompanyId(receivingCompany.getCompanyId());
            item.setReceivingCompanySapCode(receivingCompany.getCompanySapCode());
            item.setReceivingCompanySrmCode(receivingCompany.getCompanySrmCode());
            item.setReceivingCompanyName(receivingCompany.getCompanyName());
        }
    }

    private void valid() {
        Assert.isNotBlank((String)this.orderItem.getDeliveryOrderItemNo(), (String)"\u53d1\u8d27\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.orderItem.getDeliveryFactory(), (String)"\u53d1\u8d27\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.orderItem.getDeliveryStorehouse(), (String)"\u53d1\u51fa\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.orderItem.getMaterialCode(), (String)"\u7269\u6599\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.orderItem.getMaterialName(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.orderItem.getQuantity(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.orderItem.getLastUpdateTime(), (String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4");
    }
}

