/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.liby.delivery.command.deliveryInstead.BatchCreateDeliveryInsteadCmd;
import com.els.liby.delivery.command.deliveryInstead.CollectedCommand;
import com.els.liby.delivery.command.deliveryInstead.CreateAndCollectedDeliveryInsteadCmd;
import com.els.liby.delivery.command.deliveryInstead.ModifyDeliveryInsteadCmd;
import com.els.liby.delivery.command.deliveryInstead.WriteOffCommand;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.delivery.entity.OemDeliveryInsteadExample;
import com.els.liby.delivery.service.OemDeliveryInsteadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="OEM\u4ee3\u53d1\u8d27\u8868")
@Controller
@RequestMapping(value={"oemDeliveryInstead"})
public class OemDeliveryInsteadController {
    @Resource
    protected OemDeliveryInsteadService oemDeliveryInsteadService;
    @Resource
    protected OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaOEM\u4ee3\u53d1\u8d27\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<OemDeliveryInstead> oemDeliveryInsteads) {
        BatchCreateDeliveryInsteadCmd command = new BatchCreateDeliveryInsteadCmd(oemDeliveryInsteads);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91OEM\u4ee3\u53d1\u8d27\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody OemDeliveryInstead oemDeliveryInstead) {
        Assert.isNotBlank((String)oemDeliveryInstead.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyDeliveryInsteadCmd command = new ModifyDeliveryInsteadCmd(oemDeliveryInstead);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664OEM\u4ee3\u53d1\u8d27\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        OemDeliveryInsteadExample example = new OemDeliveryInsteadExample();
        example.createCriteria().andIdIn((List)ids);
        this.oemDeliveryInsteadService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2OEM\u4ee3\u53d1\u8d27\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemDeliveryInstead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemDeliveryInstead>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemDeliveryInsteadExample example = new OemDeliveryInsteadExample();
        example.setPageView((PageView<OemDeliveryInstead>)new PageView(pageNo, pageSize));
        OemDeliveryInsteadExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andDeliveryCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemDeliveryInsteadService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u786e\u8ba4")
    @RequestMapping(value={"service/collectedInsteads"})
    @ResponseBody
    public ResponseResult<String> collectedInsteads(@RequestBody List<OemDeliveryInstead> oemDeliveryInsteads) {
        Assert.isNotEmpty(oemDeliveryInsteads, (String)"\u786e\u8ba4\u5931\u8d25,\u786e\u8ba4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        CollectedCommand command = new CollectedCommand(oemDeliveryInsteads);
        Integer results = (Integer)this.invoker.invoke((AbstractCommand)command);
        ResponseResult error = new ResponseResult(ResponseCode.Fail.getCode(), "\u786e\u8ba4\u5931\u8d25", null);
        if (results == null) {
            return error;
        }
        if (oemDeliveryInsteads.size() > 1) {
            if (results < oemDeliveryInsteads.size()) {
                return ResponseResult.success((Object)("\u90e8\u5206\u786e\u8ba4\u6210\u529f\uff0c\u6210\u529f\uff1a" + results + "\u6761\uff0c\u5931\u8d25\uff1a" + (oemDeliveryInsteads.size() - results)));
            }
        } else if (results != 1) {
            return error;
        }
        return ResponseResult.success((Object)"\u786e\u8ba4\u6210\u529f");
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4e14\u786e\u8ba4\u4ee3\u53d1\u8d27")
    @RequestMapping(value={"service/createAndCollected"})
    @ResponseBody
    public ResponseResult<String> createAndSend(@RequestBody List<OemDeliveryInstead> oemDeliveryInsteads) {
        CreateAndCollectedDeliveryInsteadCmd command = new CreateAndCollectedDeliveryInsteadCmd(oemDeliveryInsteads);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        Integer results = (Integer)this.invoker.invoke((AbstractCommand)command);
        ResponseResult error = new ResponseResult(ResponseCode.Fail.getCode(), "\u4fdd\u5b58\u6210\u529f\uff0c\u786e\u8ba4\u5931\u8d25", null);
        if (results == null) {
            return error;
        }
        if (oemDeliveryInsteads.size() > 1) {
            if (results < oemDeliveryInsteads.size()) {
                return ResponseResult.success((Object)("\u4fdd\u5b58\u6210\u529f\uff0c\u90e8\u5206\u786e\u8ba4\u6210\u529f\uff0c\u6210\u529f\uff1a" + results + "\u6761\uff0c\u5931\u8d25\uff1a" + (oemDeliveryInsteads.size() - results)));
            }
        } else if (results != 1) {
            return error;
        }
        return ResponseResult.success((Object)"\u4fdd\u5b58\u4e14\u786e\u8ba4\u6210\u529f");
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u51b2\u9500")
    @RequestMapping(value={"service/WriteOff"})
    @ResponseBody
    public ResponseResult<String> WriteOff(@RequestBody(required=true) List<OemDeliveryInstead> oemDeliveryInsteads) {
        Assert.isNotEmpty(oemDeliveryInsteads, (String)"\u51b2\u9500\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        WriteOffCommand command = new WriteOffCommand(oemDeliveryInsteads);
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }
}

