/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.controller;

import com.els.base.common.AbstractCommand;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.utils.json.JsonUtils;
import com.els.liby.delivery.command.deliveryOrder.ExportOemDeliveryItemCommand;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.delivery.entity.OemDeliveryOrderItemExample;
import com.els.liby.delivery.service.OemDeliveryOrderItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="OEM\u53d1\u8d27\u5355")
@Controller
@RequestMapping(value={"oemDeliveryItem"})
public class OemDeliveryItemController {
    @Resource
    protected OrderCommandInvoker invoker;
    @Resource
    protected OemDeliveryOrderItemService oemDeliveryOrderItemService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2OEM\u53d1\u8d27\u5355\u884c\uff08\u91c7\u8d2d\u5546\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemDeliveryOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findDeliveryOrderByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemDeliveryOrderItem>> purFindDeliveryOrderByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemDeliveryOrderItemExample example = new OemDeliveryOrderItemExample();
        example.setPageView((PageView<OemDeliveryOrderItem>)new PageView(pageNo, pageSize));
        example.createCriteria().andPostingTypeEqualTo("A");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemDeliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2OEM\u53d1\u8d27\u5355\u884c\uff08\u53d1\u51fa\u5de5\u5382\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemDeliveryOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/delivery/findDeliveryOrderByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemDeliveryOrderItem>> deliveryFindDeliveryOrderByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemDeliveryOrderItemExample example = new OemDeliveryOrderItemExample();
        example.setPageView((PageView<OemDeliveryOrderItem>)new PageView(pageNo, pageSize));
        OemDeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andDeliveryCompanyIdEqualTo(company.getId());
        criteria.andIsCanDeliveryEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPostingTypeEqualTo("A");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemDeliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2OEM\u53d1\u8d27\u5355\u884c\uff08\u63a5\u6536\u5de5\u5382\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemDeliveryOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/receiving/findDeliveryOrderByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemDeliveryOrderItem>> receiveFindDeliveryOrderByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemDeliveryOrderItemExample example = new OemDeliveryOrderItemExample();
        example.setPageView((PageView<OemDeliveryOrderItem>)new PageView(pageNo, pageSize));
        OemDeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andReceivingCompanyIdEqualTo(company.getId());
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPostingTypeEqualTo("A");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemDeliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636eExcel\uff08\u53d1\u51fa\u5de5\u5382\uff09", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemShipment"), @ApiImplicitParam(name="ids", required=false, value="id\u6570\u7ec4", dataType="List<String>")})
    @RequestMapping(value={"service/delivery/exportExcel"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> deliveryExportExcel(@RequestParam(required=false) String queryParams, @RequestParam(required=false) List<String> ids, HttpServletResponse response) throws IOException {
        QueryParamWapper wapper = null;
        if (StringUtils.isNotBlank((String)queryParams)) {
            wapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
        }
        String fileName = "\u53d1\u8d27\u5355\uff08\u53d1\u51fa\u5de5\u5382\uff09";
        OemDeliveryOrderItemExample example = new OemDeliveryOrderItemExample();
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        OemDeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andDeliveryCompanyIdEqualTo(company.getId());
        criteria.andIsCanDeliveryEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPostingTypeEqualTo("A");
        if (CollectionUtils.isEmpty(ids)) {
            if (wapper != null) {
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
            }
        } else {
            criteria.andIdIn((List)ids);
        }
        List data = this.oemDeliveryOrderItemService.queryAllObjByExample((IExample)example);
        ExportOemDeliveryItemCommand command = new ExportOemDeliveryItemCommand(fileName, data, response);
        this.invoker.invoke((AbstractCommand)command);
        return null;
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636eExcel\uff08\u63a5\u6536\u5de5\u5382\uff09", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemShipment"), @ApiImplicitParam(name="ids", required=false, value="id\u6570\u7ec4", paramType="body", dataType="List<String>")})
    @RequestMapping(value={"service/receiving/exportExcel"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> receivingExportExcel(@RequestParam(required=false) String queryParams, @RequestParam(required=false) List<String> ids, HttpServletResponse response) throws IOException {
        QueryParamWapper wapper = null;
        if (StringUtils.isNotBlank((String)queryParams)) {
            wapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
        }
        String fileName = "\u53d1\u8d27\u5355\uff08\u63a5\u6536\u5de5\u5382\uff09";
        OemDeliveryOrderItemExample example = new OemDeliveryOrderItemExample();
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        OemDeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andReceivingCompanyIdEqualTo(company.getId());
        criteria.andIsCanDeliveryEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPostingTypeEqualTo("A");
        if (CollectionUtils.isEmpty(ids)) {
            if (wapper != null) {
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
            }
        } else {
            criteria.andIdIn((List)ids);
        }
        List data = this.oemDeliveryOrderItemService.queryAllObjByExample((IExample)example);
        ExportOemDeliveryItemCommand command = new ExportOemDeliveryItemCommand(fileName, data, response);
        this.invoker.invoke((AbstractCommand)command);
        return null;
    }
}

