/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.delivery.dao.OemDeliveryInsteadMapper;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.delivery.entity.OemDeliveryInsteadExample;
import com.els.liby.delivery.service.OemDeliveryInsteadService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemDeliveryInsteadService")
public class OemDeliveryInsteadServiceImpl
implements OemDeliveryInsteadService {
    @Resource
    protected OemDeliveryInsteadMapper oemDeliveryInsteadMapper;

    @CacheEvict(value={"oemDeliveryInstead"}, allEntries=true)
    public void addObj(OemDeliveryInstead t) {
        this.oemDeliveryInsteadMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemDeliveryInstead"}, allEntries=true)
    public void addAll(List<OemDeliveryInstead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemDeliveryInsteadMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemDeliveryInstead"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemDeliveryInsteadMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemDeliveryInstead"}, allEntries=true)
    public void deleteByExample(OemDeliveryInsteadExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemDeliveryInsteadMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemDeliveryInstead"}, allEntries=true)
    public void modifyObj(OemDeliveryInstead t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemDeliveryInsteadMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemDeliveryInstead"}, keyGenerator="redisKeyGenerator")
    public OemDeliveryInstead queryObjById(String id) {
        return this.oemDeliveryInsteadMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemDeliveryInstead"}, keyGenerator="redisKeyGenerator")
    public List<OemDeliveryInstead> queryAllObjByExample(OemDeliveryInsteadExample example) {
        return this.oemDeliveryInsteadMapper.selectByExample(example);
    }

    @Cacheable(value={"oemDeliveryInstead"}, keyGenerator="redisKeyGenerator")
    public PageView<OemDeliveryInstead> queryObjByPage(OemDeliveryInsteadExample example) {
        PageView<OemDeliveryInstead> pageView = example.getPageView();
        pageView.setQueryResult(this.oemDeliveryInsteadMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public OemDeliveryInstead getMaxVoucherNo(String voucherBegin) {
        OemDeliveryInsteadExample example = new OemDeliveryInsteadExample();
        example.setOrderByClause(" CREATE_TIME DESC");
        example.createCriteria().andInsteadVoucherNoLike(voucherBegin + "%");
        List<OemDeliveryInstead> lists = this.oemDeliveryInsteadMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(lists)) {
            return lists.get(0);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"oemDeliveryInstead"}, allEntries=true)
    public void modifybyExample(OemDeliveryInstead instead, OemDeliveryInsteadExample example) {
        this.oemDeliveryInsteadMapper.updateByExampleSelective(instead, example);
    }

    @Override
    @CacheEvict(value={"oemDeliveryInstead"}, allEntries=true)
    public void modifyReceivingStatusbyids(int value, List<String> deliveryInsteadIds) {
        OemDeliveryInsteadExample example = new OemDeliveryInsteadExample();
        example.createCriteria().andIdIn((List)deliveryInsteadIds);
        OemDeliveryInstead deliveryInstead = new OemDeliveryInstead();
        deliveryInstead.setReceivingStatus(value);
        this.oemDeliveryInsteadMapper.updateByExampleSelective(deliveryInstead, example);
    }
}

