/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.delivery.dao.OemDeliveryOrderItemMapper;
import com.els.liby.delivery.entity.OemDeliveryOrderItem;
import com.els.liby.delivery.entity.OemDeliveryOrderItemExample;
import com.els.liby.delivery.service.OemDeliveryOrderItemService;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemDeliveryOrderItemService")
public class OemDeliveryOrderItemServiceImpl
implements OemDeliveryOrderItemService {
    @Resource
    protected OemDeliveryOrderItemMapper oemDeliveryOrderItemMapper;

    @CacheEvict(value={"oemDeliveryOrderItem"}, allEntries=true)
    public void addObj(OemDeliveryOrderItem t) {
        this.oemDeliveryOrderItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemDeliveryOrderItem"}, allEntries=true)
    public void addAll(List<OemDeliveryOrderItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemDeliveryOrderItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemDeliveryOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemDeliveryOrderItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemDeliveryOrderItem"}, allEntries=true)
    public void deleteByExample(OemDeliveryOrderItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemDeliveryOrderItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemDeliveryOrderItem"}, allEntries=true)
    public void modifyObj(OemDeliveryOrderItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemDeliveryOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemDeliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public OemDeliveryOrderItem queryObjById(String id) {
        return this.oemDeliveryOrderItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemDeliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<OemDeliveryOrderItem> queryAllObjByExample(OemDeliveryOrderItemExample example) {
        return this.oemDeliveryOrderItemMapper.selectByExample(example);
    }

    @Cacheable(value={"oemDeliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<OemDeliveryOrderItem> queryObjByPage(OemDeliveryOrderItemExample example) {
        PageView<OemDeliveryOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.oemDeliveryOrderItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"oemDeliveryOrderItem"}, allEntries=true)
    public void addOnwayQuantity(String id, BigDecimal deliveryQuantity) {
        this.oemDeliveryOrderItemMapper.addOnwayQuantity(id, deliveryQuantity);
    }

    @Override
    @CacheEvict(value={"oemDeliveryOrderItem"}, allEntries=true)
    public void addReceivedQuantity(String id, BigDecimal deliveryQuantity) {
        this.oemDeliveryOrderItemMapper.addReceivedQuantity(id, deliveryQuantity);
    }

    @Override
    @Cacheable(value={"oemDeliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public OemDeliveryOrderItem queryObjByItemNoAndOrderNo(String deliveryOrderNo, String deliveryOrderItemNo) {
        OemDeliveryOrderItemExample example = new OemDeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo).andDeliveryOrderItemNoEqualTo(deliveryOrderItemNo);
        List<OemDeliveryOrderItem> lists = this.oemDeliveryOrderItemMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(lists)) {
            return lists.get(0);
        }
        return null;
    }

    @Override
    @Cacheable(value={"oemDeliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<String> queryItemNoByOrderNo(String orderNo) {
        OemDeliveryOrderItemExample example = new OemDeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(orderNo);
        List<OemDeliveryOrderItem> lists = this.oemDeliveryOrderItemMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(lists)) {
            return lists.stream().map(OemDeliveryOrderItem::getDeliveryOrderItemNo).distinct().collect(Collectors.toList());
        }
        return null;
    }
}

