/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.delivery.dao.OemDeliveryOrderMapper;
import com.els.liby.delivery.entity.OemDeliveryOrder;
import com.els.liby.delivery.entity.OemDeliveryOrderExample;
import com.els.liby.delivery.service.OemDeliveryOrderService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemDeliveryOrderService")
public class OemDeliveryOrderServiceImpl
implements OemDeliveryOrderService {
    @Resource
    protected OemDeliveryOrderMapper oemDeliveryOrderMapper;

    @CacheEvict(value={"oemDeliveryOrder"}, allEntries=true)
    public void addObj(OemDeliveryOrder t) {
        this.oemDeliveryOrderMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemDeliveryOrder"}, allEntries=true)
    public void addAll(List<OemDeliveryOrder> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemDeliveryOrderMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemDeliveryOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemDeliveryOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemDeliveryOrder"}, allEntries=true)
    public void deleteByExample(OemDeliveryOrderExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemDeliveryOrderMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemDeliveryOrder"}, allEntries=true)
    public void modifyObj(OemDeliveryOrder t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemDeliveryOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemDeliveryOrder"}, keyGenerator="redisKeyGenerator")
    public OemDeliveryOrder queryObjById(String id) {
        return this.oemDeliveryOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemDeliveryOrder"}, keyGenerator="redisKeyGenerator")
    public List<OemDeliveryOrder> queryAllObjByExample(OemDeliveryOrderExample example) {
        return this.oemDeliveryOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"oemDeliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<OemDeliveryOrder> queryObjByPage(OemDeliveryOrderExample example) {
        PageView<OemDeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.oemDeliveryOrderMapper.selectByExampleByPage(example));
        return pageView;
    }
}

