/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.shipment.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.liby.delivery.shipment.entity.OemShipment;
import com.els.liby.delivery.util.ShipmentExeclUtil;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;

public class ExportOemShipmentCommand
extends AbstractCommand {
    private String fileName;
    private List<OemShipment> data;
    private HttpServletResponse response;

    public ExportOemShipmentCommand(String fileName, List<OemShipment> data, HttpServletResponse response) {
        this.fileName = fileName;
        this.data = data;
        this.response = response;
    }

    public Object execute(ICommandInvoker context) {
        try {
            this.response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode(this.fileName, "UTF-8") + "\";");
            this.response.setHeader("Content-Disposition", header.toString());
            this.response.setCharacterEncoding("UTF-8");
            this.response.setContentType("application/x-msdownload;");
            List<TitleAndModelKey> titleAndModelKeys = ShipmentExeclUtil.getTitleAndModelKeys();
            ServletOutputStream outputStream = this.response.getOutputStream();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, this.data, (String)"\u88c5\u8fd0\u70b9", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        return null;
    }
}

