/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.shipment.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.company.entity.CompanySapRelation;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.liby.delivery.shipment.entity.OemShipment;
import com.els.liby.delivery.shipment.entity.OemShipmentExample;
import com.els.liby.delivery.util.ShipmentExeclUtil;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.util.OemContextUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ImportOemShipmentCommand
extends AbstractCommand {
    private Map<String, MultipartFile> fileMap;

    public ImportOemShipmentCommand(Map<String, MultipartFile> fileMap) {
        this.fileMap = fileMap;
    }

    public Object execute(ICommandInvoker context) {
        List<OemShipment> data = this.getData(this.fileMap);
        this.init(data);
        data.stream().forEach(shipment -> {
            shipment.setUpdateTime(new Date());
            shipment.setUpdateUserId(this.getPurUser().getId());
            shipment.setUpdateUserName(this.getPurUser().getNickName());
            if (OemContextUtils.getOemShipmentService().isExist(shipment.getFactory(), shipment.getStockSpaceCode(), shipment.getShipmentDesc())) {
                OemShipmentExample example = new OemShipmentExample();
                example.createCriteria().andFactoryEqualTo(shipment.getFactory()).andStockSpaceCodeEqualTo(shipment.getStockSpaceCode()).andShipmentDescEqualTo(shipment.getShipmentDesc()).andIsEnableEqualTo(Constant.YES_INT);
                OemContextUtils.getOemShipmentService().modifyObjByExample((OemShipment)shipment, example);
            } else {
                shipment.setCreateTime(new Date());
                shipment.setCreateUserId(this.getPurUser().getId());
                shipment.setCreateUserName(this.getPurUser().getNickName());
                OemContextUtils.getOemShipmentService().addObj((Serializable)shipment);
            }
        });
        return null;
    }

    private void init(List<OemShipment> data) {
        data.stream().forEach(shipment -> {
            Organization factory = this.getFactory(shipment.getFactory());
            shipment.setFactoryId(factory.getId());
            shipment.setFactoryName(factory.getDescription());
            Organization stockSpace = this.getStockSpace(shipment.getStockSpaceCode(), shipment.getFactory());
            shipment.setStockSpaceId(stockSpace.getId());
            shipment.setStockSpaceCode(stockSpace.getCode());
            shipment.setStockSpaceRemark(stockSpace.getDescription());
            CompanySapRelation relation = this.getCompany(shipment.getCompanySapCode());
            shipment.setCompanyId(relation.getCompanyId());
            shipment.setCompanySrmCode(relation.getCompanyCode());
            shipment.setCompanyName(relation.getCompanyFullName());
            shipment.setIsEnable(Constant.YES_INT);
        });
    }

    private CompanySapRelation getCompany(String companySapCode) {
        CompanySapRelation relation = OemContextUtils.getCompanySapRelationService().findBySapSupplierCode(companySapCode);
        Assert.isNotNull((Object)relation, (String)MessageFormat.format("\u4f9b\u5e94\u5546\uff1a{0} \u4e0d\u5b58\u5728", companySapCode));
        return relation;
    }

    private Organization getStockSpace(String stockSpaceCode, String factory) {
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andCodeEqualTo(stockSpaceCode).andFactorycodeEqualTo(factory).andOrganizationTypeEqualTo("T001L");
        List list = OemContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)list, (String)MessageFormat.format("\u5de5\u5382\uff1a{0}\u4e0b\u6ca1\u6709\u5e93\u5b58\u5730\u70b9\uff1a{1}", factory, stockSpaceCode));
        return (Organization)list.get(0);
    }

    private Organization getFactory(String factory) {
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andCodeEqualTo(factory).andOrganizationTypeEqualTo("T001W");
        List list = OemContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)list, (String)MessageFormat.format("\u5de5\u5382\uff1a{0} \u4e0d\u5b58\u5728", factory));
        return (Organization)list.get(0);
    }

    private List<OemShipment> getData(Map<String, MultipartFile> fileMap) {
        ArrayList<OemShipment> shipments = new ArrayList();
        try {
            MultipartFile file = ShipmentExeclUtil.vaildFile(fileMap);
            InputStream inputStream = file.getInputStream();
            List<TitleAndModelKey> titleAndModelKeyList = ShipmentExeclUtil.getTitleAndModelKeys();
            shipments = ExcelUtils.importExcelDataToMap((InputStream)inputStream, (int)0, (int)1, (int)0, titleAndModelKeyList, OemShipment.class);
            if (CollectionUtils.isEmpty(shipments)) {
                throw new CommonException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("EVENT:\u5bfc\u5165\u88c5\u8fd0\u70b9\u5f02\u5e38{0}", (Object)e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
        return shipments;
    }
}

