/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.shipment.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.liby.delivery.shipment.command.CreateOemShipmentCommand;
import com.els.liby.delivery.shipment.command.ExportOemShipmentCommand;
import com.els.liby.delivery.shipment.command.ImportOemShipmentCommand;
import com.els.liby.delivery.shipment.command.ModifyOemShipmentCommand;
import com.els.liby.delivery.shipment.entity.OemShipment;
import com.els.liby.delivery.shipment.entity.OemShipmentExample;
import com.els.liby.delivery.shipment.service.OemShipmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u8f6c\u8fd0\u70b9")
@Controller
@RequestMapping(value={"oemShipment"})
public class OemShipmentController {
    @Resource
    protected OemShipmentService oemShipmentService;
    @Resource
    protected OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8f6c\u8fd0\u70b9")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody OemShipment oemShipment) {
        CreateOemShipmentCommand command = new CreateOemShipmentCommand(oemShipment);
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success((Object)oemShipment.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8f6c\u8fd0\u70b9")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody OemShipment oemShipment) {
        Assert.isNotBlank((String)oemShipment.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyOemShipmentCommand command = new ModifyOemShipmentCommand(oemShipment);
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8f6c\u8fd0\u70b9")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        OemShipmentExample example = new OemShipmentExample();
        OemShipment shipment = new OemShipment();
        shipment.setIsEnable(Constant.NO_INT);
        example.createCriteria().andIdIn((List)ids);
        this.oemShipmentService.modifyObjByExample(shipment, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8f6c\u8fd0\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemShipment", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OemShipment>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OemShipmentExample example = new OemShipmentExample();
        example.setPageView((PageView<OemShipment>)new PageView(pageNo, pageSize));
        OemShipmentExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.oemShipmentService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa\u5168\u90e8\u6570\u636eExcel", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OemShipment", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/exportAll"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> exportAll(@RequestBody(required=false) QueryParamWapper wapper, HttpServletResponse response) {
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String fileName = MessageFormat.format("\u88c5\u8fd0\u70b9-{0}.xls", dateStr);
        OemShipmentExample example = new OemShipmentExample();
        example.setOrderByClause("CREATE_TIME DESC");
        OemShipmentExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List list = this.oemShipmentService.queryAllObjByExample((IExample)example);
        ExportOemShipmentCommand command = new ExportOemShipmentCommand(fileName, list, response);
        this.invoker.invoke((AbstractCommand)command);
        return null;
    }

    @ApiOperation(value="\u5bfc\u51fa\u52fe\u9009\u6570\u636eExcel", httpMethod="GET")
    @RequestMapping(value={"service/exportByIds"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> exportByIds(@RequestParam(required=true) List<String> ids, HttpServletResponse response) {
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String fileName = MessageFormat.format("\u88c5\u8fd0\u70b9-{0}.xls", dateStr);
        OemShipmentExample example = new OemShipmentExample();
        example.setOrderByClause("CREATE_TIME DESC");
        OemShipmentExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andIdIn((List)ids);
        List list = this.oemShipmentService.queryAllObjByExample((IExample)example);
        ExportOemShipmentCommand command = new ExportOemShipmentCommand(fileName, list, response);
        this.invoker.invoke((AbstractCommand)command);
        return null;
    }

    @ApiOperation(value="\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", httpMethod="GET")
    @RequestMapping(value={"service/importMould"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> importMould(HttpServletResponse response) {
        String fileName = "\u88c5\u8fd0\u70b9\u5bfc\u5165\u6a21\u677f.xls";
        ExportOemShipmentCommand command = new ExportOemShipmentCommand(fileName, null, response);
        this.invoker.invoke((AbstractCommand)command);
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7excel\u5bfc\u5165\u914d\u989d\u4fe1\u606f")
    @ResponseBody
    @RequestMapping(value={"service/importByExcel"})
    public ResponseResult<String> importByExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        ImportOemShipmentCommand command = new ImportOemShipmentCommand(fileMap);
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((AbstractCommand)command);
        return ResponseResult.success();
    }
}

