/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.delivery.shipment.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.delivery.shipment.dao.OemShipmentMapper;
import com.els.liby.delivery.shipment.entity.OemShipment;
import com.els.liby.delivery.shipment.entity.OemShipmentExample;
import com.els.liby.delivery.shipment.service.OemShipmentService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemShipmentService")
public class OemShipmentServiceImpl
implements OemShipmentService {
    @Resource
    protected OemShipmentMapper oemShipmentMapper;

    @CacheEvict(value={"oemShipment"}, allEntries=true)
    public void addObj(OemShipment t) {
        this.oemShipmentMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemShipment"}, allEntries=true)
    public void addAll(List<OemShipment> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemShipmentMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemShipment"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemShipmentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemShipment"}, allEntries=true)
    public void deleteByExample(OemShipmentExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemShipmentMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemShipment"}, allEntries=true)
    public void modifyObj(OemShipment t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemShipmentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemShipment"}, keyGenerator="redisKeyGenerator")
    public OemShipment queryObjById(String id) {
        return this.oemShipmentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemShipment"}, keyGenerator="redisKeyGenerator")
    public List<OemShipment> queryAllObjByExample(OemShipmentExample example) {
        return this.oemShipmentMapper.selectByExample(example);
    }

    @Cacheable(value={"oemShipment"}, keyGenerator="redisKeyGenerator")
    public PageView<OemShipment> queryObjByPage(OemShipmentExample example) {
        PageView<OemShipment> pageView = example.getPageView();
        pageView.setQueryResult(this.oemShipmentMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"oemShipment"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void modifyObjByExample(OemShipment shipment, OemShipmentExample example) {
        this.oemShipmentMapper.updateByExampleSelective(shipment, example);
    }

    @Override
    @Cacheable(value={"oemShipment"}, keyGenerator="redisKeyGenerator")
    public boolean isExist(String factory, String stockSpaceCode, String shipment) {
        OemShipment oemShipment = this.findByFactoryAndShipmentCode(factory, stockSpaceCode, shipment);
        return oemShipment != null;
    }

    @Override
    public OemShipment findByFactoryAndShipmentCode(String factory, String stockSpaceCode, String shipment) {
        OemShipmentExample example = new OemShipmentExample();
        example.createCriteria().andFactoryEqualTo(factory).andStockSpaceCodeEqualTo(stockSpaceCode).andShipmentDescEqualTo(shipment).andIsEnableEqualTo(Constant.YES_INT);
        List<OemShipment> list = this.oemShipmentMapper.selectByExampleByPage(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }
}

