/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.receiving.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.liby.receiving.entity.OemReceivingInstead;
import com.els.liby.receiving.entity.OemReceivingInsteadExample;
import com.els.liby.sap.BAPI2017GMHEADRET;
import com.els.liby.sap.ZSRMDSHRFCRETPZ;
import com.els.liby.sap.ZSRMRFCDELIVERYCONResponse;
import com.els.liby.sap.ZSRMRFCOBDRS;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemDeliveryBackSapUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.util.CollectionUtils;

public class CollectedBackSapCommand
extends AbstractCommand<List<String>> {
    private static String PAT = "000000000000000000";
    private List<OemReceivingInstead> oemReceivingInsteads;

    public CollectedBackSapCommand(List<OemReceivingInstead> oemReceivingInsteads) {
        this.oemReceivingInsteads = oemReceivingInsteads;
    }

    public List<String> execute(ICommandInvoker context) {
        String xmlParams = this.getXmlParams(this.oemReceivingInsteads);
        ZSRMRFCDELIVERYCONResponse response = OemDeliveryBackSapUtil.backToSap(xmlParams);
        List<ZSRMRFCOBDRS> lists = response.getETINFODATA().getItem();
        Assert.isNotEmpty(lists, (String)"SAP\u751f\u6210\u51ed\u8bc1\u5931\u8d25");
        List<String> VoucherCodes = lists.stream().map(z -> {
            String code = z.getZDSHPZ();
            if ("S".equals(z.getTYPE())) {
                this.confirmSuccess(code, z.getPZITEM().getItem());
                return code;
            }
            try {
                this.confirmFail(code, z.getPZITEM().getItem().get(0).getRETURN().getItem().get(0).getMESSAGE());
            }
            catch (NullPointerException e) {
                this.confirmFail(code, z.getMSG());
            }
            return null;
        }).filter(code -> StringUtils.isNotBlank((String)code)).collect(Collectors.toList());
        return VoucherCodes;
    }

    private void confirmSuccess(String code, List<ZSRMDSHRFCRETPZ> pzLists) {
        ZSRMDSHRFCRETPZ pz = CollectionUtils.isEmpty(pzLists) ? null : pzLists.get(0);
        BAPI2017GMHEADRET doc = pz == null ? null : pz.getBAPIRET();
        OemReceivingInstead instead = new OemReceivingInstead();
        instead.setConfirmDate(new Date());
        instead.setReceivingMoveType(pz == null ? null : pz.getBWART());
        instead.setReceivingSapVoucherNo(doc == null ? "" : doc.getMATDOC());
        instead.setConfirmStatus(OemConfirmStatusEnum.COLLECTED.getValue());
        OemReceivingInsteadExample example = new OemReceivingInsteadExample();
        example.createCriteria().andReceivingVoucherNoEqualTo(code);
        OemContextUtils.getOemReceivingInsteadService().modifybyExample(instead, example);
    }

    private void confirmFail(String code, String msg) {
        OemReceivingInstead instead = new OemReceivingInstead();
        instead.setConfirmStatus(OemConfirmStatusEnum.COLLECTED_FAIL.getValue());
        instead.setConfirmFailReason(msg);
        OemReceivingInsteadExample example = new OemReceivingInsteadExample();
        example.createCriteria().andReceivingVoucherNoEqualTo(code);
        OemContextUtils.getOemReceivingInsteadService().modifybyExample(instead, example);
    }

    private String getXmlParams(List<OemReceivingInstead> oemReceivingInsteads) {
        StringBuffer sb = new StringBuffer();
        sb.append("<IT_DATAS>");
        oemReceivingInsteads.stream().forEach(o -> {
            sb.append(" <item>");
            sb.append(" <ZDSHPZ>" + o.getReceivingVoucherNo() + "</ZDSHPZ>");
            sb.append(" <BLDAT>" + DateFormatUtils.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd") + "</BLDAT>");
            sb.append(" <WERKS>" + o.getReceivingFactory() + "</WERKS>");
            sb.append(" <BKTXT>" + o.getReceivingRemarks() + "</BKTXT>");
            sb.append(" <ITEMS>");
            sb.append(" <item>");
            sb.append(" <ZDSHPZ>" + o.getReceivingVoucherNo() + "</ZDSHPZ>");
            sb.append(" <ZDSHHH>" + o.getReceivingVoucherItemNo() + "</ZDSHHH>");
            sb.append(" <VBELN>" + o.getDeliveryOrderNo() + "</VBELN>");
            sb.append(" <POSNR>" + o.getDeliveryOrderItemNo() + "</POSNR>");
            sb.append(" <MATNR>" + PAT.substring(0, PAT.length() - o.getMaterialCode().length()) + o.getMaterialCode() + "</MATNR>");
            sb.append(" <WERKS>" + o.getReceivingFactory() + "</WERKS>");
            sb.append(" <LGORT>" + o.getReceivingStorehouse() + "</LGORT>");
            sb.append(" <BUDAT>" + DateFormatUtils.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd") + "</BUDAT>");
            sb.append(" <VGBEL>" + o.getTransferOrderNo() + "</VGBEL>");
            sb.append(" <VGPOS>" + o.getTransferOrderItemNo() + "</VGPOS>");
            sb.append(" <DETAL>");
            sb.append(" <item>");
            sb.append(" <ETENR>1</ETENR>");
            sb.append(" <CHARG>" + o.getDeliveryBatchNo() + "</CHARG>");
            sb.append(" <LFIMG>" + o.getDeliveryQuantity() + "</LFIMG>");
            sb.append(" <VRKME>" + o.getUnit() + "</VRKME>");
            sb.append(" </item>");
            sb.append(" </DETAL>");
            sb.append(" </item>");
            sb.append(" </ITEMS>");
            sb.append(" </item>");
        });
        sb.append("</IT_DATAS>");
        sb.append("<IV_DSHLX>I</IV_DSHLX>");
        return sb.toString();
    }
}

